// ==========================================================================
//code=EUC	tab=4
//
// wizd:	MediaWiz Server daemon.
//
// 		wizd.h
//											$Revision: 1.19 $
//											$Date: 2003/09/07 10:40:18 $
//
//	٤ƼǤǤʤޤġ
//  ΥեȤˤĤVertexLink䤤碌ʤǤ
// ==========================================================================
#ifndef	_WIZD_H
#define	_WIZD_H


#include	"wizd_tools.h"

// ======================
// define 
// ======================

#define		SERVER_NAME		"wizd 0.05"
#define		SERVER_DETAIL	"MediaWiz Server Daemon."


#ifndef TRUE
#define	TRUE	(1)
#endif
#ifndef FALSE
#define	FALSE	(0)
#endif





#define		LISTEN_BACKLOG	(32)

#define		SEND_BUFFER_SIZE	(1024*128)


#define DEFAULT_SERVER_PORT (8000)
#define	DEFAULT_DOCUMENT_ROOT	"/"


#define	DEFAULT_FLAG_DAEMON			TRUE
#define	DEFAULT_FLAG_AUTO_DETECT	TRUE





#define	DEFAULT_MIME_TYPE		"text/plain"

#define	DEFAULT_INDEX_FILENAME	"index.html"



#define	DEFAULT_CONF_FILENAME1	"./wizd.conf"
#define	DEFAULT_CONF_FILENAME2	"/usr/local/wizd/wizd.conf"
#define	DEFAULT_CONF_FILENAME3	"/etc/wizd.conf"


#define	DEFAULT_FLAG_DEBUG_LOG_OUTPUT	FALSE
#define	DEFAULT_DEBUG_LOG_FILENAME		"/tmp/wizd_debug.log"


#define	DEFAULT_SERVER_NAME			"Linux"


#define	DEFAULT_FLAG_USE_SKIN		TRUE

#define	DEFAULT_SKINDATA_ROOT		"./skin"
#define	DEFAULT_SKINDATA_NAME		"default"



#define	SORT_NONE				(0)
#define	SORT_NAME_UP			(1)
#define	SORT_NAME_DOWN			(2)
#define	SORT_TIME_UP			(3)
#define	SORT_TIME_DOWN			(4)
#define	SORT_SIZE_UP			(5)
#define	SORT_SIZE_DOWN			(6)

#define	DEFAULT_SORT_RULE		SORT_NONE

#define	DEFAULT_PAGE_LINE_MAX	(20)


#define	NKF_CODE_SJIS			"s"
#define	NKF_CODE_EUC			"e"

#define	DEFAULT_CLIENT_LANGUAGE_CODE	NKF_CODE_SJIS




#define	HTTP_USER_AGENT		"User-agent:"
#define	HTTP_RANGE			"Range:"

#define	HTTP_OK 			"HTTP/1.0 200 OK\r\n"
#define	HTTP_NOT_FOUND 		"HTTP/1.0 404 File Not Found\r\n"
#define HTTP_CONTENT_LENGTH	"Content-Length: %d\r\n"
#define	HTTP_ACCEPT_RANGES	"Accept-Ranges: bytes\r\n"
#define HTTP_CONTENT_TYPE 	"Content-Type: %s\r\n"
#define	HTTP_SERVER_NAME	"Server: %s\r\n"
#define	HTTP_CONNECTION		"Connection: Close\r\n"
#define HTTP_END			"\r\n"






// MIME_LIST_T.file_type 
#define		TYPE_STREAM_FILE		(0)
#define		TYPE_NORMAL_FILE		(1)
#define		TYPE_DIRECTORY			(2)


// ==========================================================================
// MIMEꥹ¸ѹ¤
// ==========================================================================
typedef struct {
	unsigned char	*mime_name;
	unsigned char	*file_extension;
	int				file_type;
} MIME_LIST_T;


// ==========================================================================
// ĥѴơ֥
// ==========================================================================
typedef struct {
	unsigned char	*org_extension;
	unsigned char	*rename_extension;
} EXTENSION_CONVERT_LIST_T;





// ==========================================================================
// HTTP Request¸ѹ¤
// ==========================================================================
typedef struct {
	unsigned char 	recv_uri[FILENAME_MAX];
	unsigned char 	user_agent[256];

	unsigned int	range_start_pos;
	unsigned int	range_end_pos;

	unsigned int	file_size;
	unsigned int	content_length;

	unsigned char	mime_type[128];
	unsigned char	send_filename[FILENAME_MAX];


	unsigned char	action[128];	// ?action=  
	int				page;			// ?page=	ǻꤵ줿ɽڡ


} HTTP_RECV_INFO;



// ==========================================================================
// Υѥ᡼¸ѹ¤
// ==========================================================================
typedef struct {


	// -----------------
	// ƥ
	// -----------------

	// ǡ󲽤/ʤ
	char			flag_daemon;

	// ǥХå
	char			flag_debug_log_output;
	unsigned char	debug_log_filename[FILENAME_MAX];

	// -----------------
	// ưз
	// -----------------

	// Хۥ̾
	unsigned char	server_name[32];

	char			flag_auto_detect;
	unsigned char	auto_detect_bind_ip_address[32];

	// --------------------
	// HTTP Server
	// --------------------

	// HTTP Server Port
	int		server_port;

	// Document Root
	unsigned char 	document_root[FILENAME_MAX];



	// ----------------------
	// ɽ
	// ----------------------

	// MediaWiz θ쥳(libnkfΥץ)
	unsigned char	client_language_code[4];


	// Ѥ롿ʤ
	char			flag_use_skin;

	// ֤
	unsigned char	skin_root[FILENAME_MAX];

	// ̾
	unsigned char	skin_name[32];

	// ե륽ȤΥ롼
	int				sort_rule;

	//եꥹȤΣڡκɽ
	int		page_line_max;



} GLOBAL_PARAM_T;




// ======================
// extern 
// ======================

// ------------------
// Ƽꥹ
// ------------------
extern GLOBAL_PARAM_T	global_param;
extern MIME_LIST_T	mime_list[];
extern EXTENSION_CONVERT_LIST_T extension_convert_list[];


// ------------------
// Хؿ
// ------------------


// wizd 
extern void global_param_init(void);

// config_file(wizd.conf) ɤ߹
extern void config_file_read(void);

// MediaWiz ưϿ
extern void	server_detect(void);


// HTTP Ԥ
extern void server_listen(void);	


// HTTP
extern void server_http_process(int accept_socket); 






// SVIեϡֿ
extern int http_joint_file_response(int accept_socket, HTTP_RECV_INFO *http_recv_info_p );

// եֿ
extern int http_file_response(int accept_socket, HTTP_RECV_INFO *http_recv_info_p);


// ˥塼
void http_menu(int accept_socket, HTTP_RECV_INFO *http_recv_info);







// ========================================================
// ʸѴ
// libnkf򤽤Τޤ޻ѡͤ˴ա()
// http://www.mr.hum.titech.ac.jp/~morimoto/libnkf/
// ========================================================
int nkf(const char *, char *, size_t, const char *);



#endif

