// ==========================================================================
//code=EUC	tab=4
//
// wizd:	MediaWiz Server daemon.
//
// 		wizd_http.c
//											$Revision: 1.15 $
//											$Date: 2003/09/07 06:46:23 $
//
//	٤ƼǤǤʤޤġ
//  ΥեȤˤĤVertexLink䤤碌ʤǤ
// ==========================================================================
#include <ctype.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <memory.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/stat.h>
#include <unistd.h>
#include <netinet/in.h>
#include <dirent.h>


#include "wizd.h"




static int http_header_receive(int accept_socket, HTTP_RECV_INFO *http_recv_info);
static int line_receive(int accept_socket, unsigned char *line_buf_p, int line_max);

static int http_file_check( HTTP_RECV_INFO *http_recv_info_p);


// **************************************************************************
//  HTTP
// **************************************************************************
void 	server_http_process(int accept_socket)
{
	int					result;
	HTTP_RECV_INFO	http_recv_info;	//HTTP¸¤


	memset(&http_recv_info, 0, sizeof(http_recv_info));


	// ----------------------------------------
	// HTTP ꥯȥإå
	// ----------------------------------------
	debug_log_output("HTTP Header receive start!\n");

	result = http_header_receive(accept_socket,  &http_recv_info);
	if ( result != 0 ) // 顼å
	{
		// 顼å
		debug_log_output("http_header_receive() Error. result=%d\n", result);
		// åȥ
		close(accept_socket);
		return;
	}
	debug_log_output("HTTP Header receive end!\n");



	debug_log_output("recv_uri:'%s'\n", http_recv_info.recv_uri);
	debug_log_output("user_agent:'%s'\n", http_recv_info.user_agent);

	debug_log_output("range_start_pos=%d\n", http_recv_info.range_start_pos);
	debug_log_output("range_end_pos=%d\n", http_recv_info.range_end_pos);

	debug_log_output("file_size=%d\n", 		http_recv_info.file_size );
	debug_log_output("content_length=%d\n", http_recv_info.content_length );


	// ----------------------------------------
	// äURIγĥҤrenameоݤʤrename
	// ----------------------------------------
	extension_del_rename(http_recv_info.recv_uri);

	// ---------------------------
	// եå
	// ---------------------------
	result = http_file_check(&http_recv_info);


	// եΤʤСž
	if ( result == 0 )
	{
		// ----------------------------------------
		// եμ
		// HTTPꥯȥإå˽äƥǡֿ
		// ----------------------------------------
		debug_log_output("HTTP response start!\n");
		http_file_response(accept_socket, &http_recv_info);
		debug_log_output("HTTP response end!(resut=%d)\n", result);
	}
	else if ( result == 2 )
	{
		// ----------------------------------------
		// SVIեʡ
		// SVIեƥǡֿ
		// ----------------------------------------
		debug_log_output("HTTP joint file response start!\n");
		http_joint_file_response(accept_socket, &http_recv_info);
		debug_log_output("HTTP joint file response end!(resut=%d)\n", result);
	}
	else 
	{
		// -------------------------------------
		// ǥ쥯ȥ긡
		// եꥹȤֿ
		// -------------------------------------
		debug_log_output("HTTP file menu create.\n");
		http_menu(accept_socket, &http_recv_info);
		debug_log_output("HTTP file menu end.\n");
	}




	// åȥ
	close(accept_socket);

	return;
}






// **************************************************************************
// HTTPإåƲϤ롣
// 
// ΤGETΤߡGETʳΥ᥽åɤ褿饨顼
// ȤꤢURIuser_agentΤ߲ϡ
// URIϡURIǥɤ롣
//
//	return: 0 		ｪλ
//	return: 0ʳ 	顼
// **************************************************************************
static int http_header_receive(int accept_socket, HTTP_RECV_INFO *http_recv_info_p)
{
	int result = 0;
	int	recv_len;
    unsigned char	line_buf[1024];	// 礭ˡ
    unsigned char 	work_buf[1024];
    unsigned char 	work_buf2[1024];
    unsigned char 	split1[1024];
    unsigned char 	split2[1024];

	int		ret;
	int		i;
	



	// ================================
	// ԤŤ HTTPإå
	// ================================
	for (i=0;;i++)
	{
		// 1Լ ¹ԡ
		memset(line_buf, '\0', sizeof(line_buf));
		recv_len = line_receive(accept_socket, line_buf, sizeof(line_buf));

		// debug. إåɽ
		debug_log_output("'%s'(%d byte)\n", line_buf, recv_len );

		// Ƥå
		if ( recv_len == 0 ) // ԸΡإåλ
		{
			break;
		}
		else if ( recv_len < 0 ) // 
		{
			return ( -1 );	
		}

		// --------------------------
		// GETåå
		// --------------------------
		if ( i == 0 ) // ܤΤߥå
		{
			debug_log_output("URI Check start.'%s'\n", line_buf);

			// GET롩
			if ( strstr(line_buf, "GET") == NULL )
			{
				debug_log_output("'GET' not found. error.");
				return ( -1 );
			}

			// ǽΥڡޤǤ
			cut_before_character(line_buf, ' ');

			// ˥ڡФƤȤθޤǤ
			cut_after_character(line_buf, ' ');

			// ===========================
			// GETץ
			// ===========================

			// '?'¸ߤ뤫å
			if ( strchr(line_buf, '?') != NULL )
			{

				strncpy(work_buf, line_buf, sizeof(work_buf));

				// '?'򥫥å
				cut_before_character(work_buf, '?' );
				debug_log_output("work_buf = '%s'", work_buf );

				while ( 1 ) 
				{
					memset(split1, '\0', sizeof(split1));
					memset(split2, '\0', sizeof(split2));

					// ǽо줹'&'ʬ
					ret = sentense_split(work_buf, '&', split1, split2 );
					if ( ret == 0 ) // ʬ
					{
						strncpy(work_buf, split2, sizeof(work_buf));
					}
					else if (strlen(work_buf) > 0) // ޤwork_bufȤ롩
					{
						strncpy( split1, work_buf, sizeof(split1));
						strncpy( work_buf, "", sizeof(work_buf));
					}
					else // λ
					{
						break;
					}

					// -------------------------------------
					// split1 ϳ
					// ĶľΤӤǡ
					// -------------------------------------

					// URIǥ
					uri_decode(work_buf2, sizeof(work_buf2), split1, sizeof(split1) );

					// "page="뤫Ĵ
					if (strncasecmp( work_buf2, "page=", strlen("page=") ) == 0 )
					{
						// = 
						cut_before_character(work_buf2, '=');
						if ( strlen(work_buf2) > 0 )
						{
							// ¤Τͤ¸
							http_recv_info_p->page = atoi(work_buf2);
						}

						continue;
					}

					// "action="뤫Ĵ
					if (strncasecmp( work_buf2, "action=", strlen("action=") ) == 0 )
					{
						// = 
						cut_before_character(work_buf2, '=');

						// ¤Τͤ¸
						strncpy(http_recv_info_p->action, work_buf2, sizeof(http_recv_info_p->action));
						continue;
					}
				}
			}

			debug_log_output("http_recv_info_p->page = '%d'", http_recv_info_p->page);
			debug_log_output("http_recv_info_p->action = '%s'", http_recv_info_p->action);

			// URIǥ
			cut_after_character(line_buf, '?');
			uri_decode(work_buf, sizeof(work_buf), line_buf, sizeof(line_buf) );
			strncpy(line_buf, work_buf, sizeof(line_buf));
			debug_log_output("URI(decoded):'%s'\n", line_buf);


			// ¤Τ¸
			strncpy(http_recv_info_p->recv_uri, line_buf, sizeof(http_recv_info_p->recv_uri));

			


			continue;
		}

		// User-agentڤФ
		if ( strncmp(line_buf, HTTP_USER_AGENT, strlen(HTTP_USER_AGENT) ) == 0 )
		{
			debug_log_output("User-agent: Detect.\n");
			// ':'ڤ
			cut_before_character(line_buf, ':');
			cut_first_character(line_buf, ' ');

			// ¤Τ¸
			strncpy( http_recv_info_p->user_agent, line_buf, sizeof(http_recv_info_p->user_agent));
			continue;
		}

		// Range뤫å
		if ( strncmp(line_buf, HTTP_RANGE,	strlen(HTTP_RANGE) ) == 0 )
		{
			debug_log_output("Range: Detect.\n");
			// ':' ڤ롣
			cut_before_character(line_buf, ':');
			cut_first_character(line_buf, ' ');

			// '=' ڤ
			cut_before_character(line_buf, '=');

			// '-'ʬ䡣
			sentense_split(line_buf, '-', work_buf, work_buf2);

			debug_log_output("wrok_buf='%s'\n", work_buf);
			debug_log_output("wrok_buf2='%s'\n", work_buf2);

			// ͤʸ󢪿Ѵ
			//sscanf(work_buf, "%d", &http_recv_info_p->range_start_pos);
			http_recv_info_p->range_start_pos  =atoi(work_buf);
			
			if ( strlen(work_buf2) > 0 )
			{
				//sscanf(work_buf2, "%d", &http_recv_info_p->range_end_pos );
				http_recv_info_p->range_end_pos = atoi(work_buf2);
			}

		
			debug_log_output("range_start_pos=%d\n", http_recv_info_p->range_start_pos);
			debug_log_output("range_end_pos=%d\n", http_recv_info_p->range_end_pos);
			continue;
		}


	}

	return result;
}



// **************************************************************************
// accept_socket顢(CRLFLFñȤޤ)
// CRLFϺ롣
// return롣
// **************************************************************************
static int line_receive(int accept_socket, unsigned char *line_buf_p, int line_max)
{
	unsigned char byte_buf;
	int 	line_len;
	int		recv_len;

	unsigned char *line_buf_work_p;

	line_buf_work_p = line_buf_p;
	line_len = 0;

	// Լ¹
	while ( 1 )
	{
   		recv_len = recv(accept_socket, &byte_buf, 1, 0);
		if ( recv_len != 1 ) // ԥå
		{
			return ( -1 );
		}

		// CR/LFå
		if ( byte_buf == '\r' )
		{
			continue;
		}
		else if ( byte_buf == '\n' )
		{
			break;
		}

		// Хåե˥å
		*line_buf_work_p = byte_buf;
		line_buf_work_p++;
		line_len++;

		// printf("line_len=%d, buf='%s'\n", line_len, line_buf_p);

		// Хåեå
		if ( line_len >= line_max) 
		{
			// ХåեСե
			debug_log_output("line_buf over flow.");
			return ( -1 );
		}
	}

	return line_len;
}


// **************************************************************************
// ꥯȤ줿URIΥեå
// ret		 0:
//			 1:ǥ쥯ȥ
//			 2:SVIեʡ
// **************************************************************************
static int http_file_check( HTTP_RECV_INFO *http_recv_info_p)
{
	struct stat send_filestat;
	int result;
	int	i;

	unsigned char	file_extension[FILENAME_MAX];


	// ---------------
	// ѿ
	// ---------------
	memset(http_recv_info_p->send_filename, '\0', sizeof(http_recv_info_p->send_filename));
	strncpy(http_recv_info_p->mime_type, DEFAULT_MIME_TYPE, sizeof(http_recv_info_p->mime_type));

	memset(file_extension, '\0', sizeof(file_extension));



	// -------------------------
	// եå
	// -------------------------
	strncpy(http_recv_info_p->send_filename, global_param.document_root, sizeof(http_recv_info_p->send_filename));
	strncat(http_recv_info_p->send_filename, http_recv_info_p->recv_uri, sizeof(http_recv_info_p->send_filename));

	// '/' ŤʤäƤȤνʣӽ
	duplex_character_to_unique(http_recv_info_p->send_filename, '/');

	debug_log_output("http_recv_info_p->send_filename='%s'\n", http_recv_info_p->send_filename);

	// ------------------------------------------------------------
	// ե뤢뤫å
	// ------------------------------------------------------------
	result = stat(http_recv_info_p->send_filename, &send_filestat);
	debug_log_output("stat: result=%d, st_mode=%0X, S_ISREG=%d\n", result, send_filestat.st_mode, S_ISREG(send_filestat.st_mode));


	if ( ( result == 0 ) && (( S_ISREG(send_filestat.st_mode) == 1 ) || ( S_ISLNK(send_filestat.st_mode) == 1 )))
	{
		 // եΤȸ
		debug_log_output("'%s' is File!!");
		debug_log_output("send_filestat.st_size= %d\n", (int)send_filestat.st_size);



		// -------------------------------------------
		// եγĥҤꡢContent-type 
		// -------------------------------------------
		strncpy(file_extension, http_recv_info_p->send_filename, sizeof(file_extension));
		cut_before_last_character(file_extension, '.');
		debug_log_output("http_recv_info_p->send_filename='%s', file_extension='%s'\n", http_recv_info_p->send_filename, file_extension);

		for (i=0;;i++)
		{
			if ( mime_list[i].mime_name == NULL )
				break;

			if ( strcasecmp(mime_list[i].file_extension, file_extension) == 0 )
			{
				strncpy(http_recv_info_p->mime_type, mime_list[i].mime_name, sizeof(http_recv_info_p->mime_type));
				break;
			}
		}
		debug_log_output("mime_type='%s'\n", http_recv_info_p->mime_type);


		// SVIեȼΥեʬ
		if ( strcasecmp(file_extension, "svi") == 0  )
		{

			return ( 2 );	// sviե
		}
		else
		{

			// ===========================
			// ǡ
			// ===========================
			http_recv_info_p->file_size  	= (unsigned int)send_filestat.st_size;
			if (http_recv_info_p->range_end_pos == 0 ) // range_end_posRangeǻ̵ΤФ
			{
				http_recv_info_p->range_end_pos			= http_recv_info_p->file_size - 1;
			}
			http_recv_info_p->content_length	= (http_recv_info_p->range_end_pos - http_recv_info_p->range_start_pos) + 1;

			debug_log_output("http_recv_info_p->range_start_pos = %d\n", http_recv_info_p->range_start_pos);
			debug_log_output("http_recv_info_p->range_end_pos = %d\n", http_recv_info_p->range_end_pos);
			debug_log_output("http_recv_info_p->file_size = %d\n", http_recv_info_p->file_size);
			debug_log_output("http_recv_info_p->content_length = %d\n", http_recv_info_p->content_length);

			return ( 0 );	// File
		}
	}
	else if ( ( result == 0 ) && ( S_ISDIR(send_filestat.st_mode) == 1 ) ) // ǥ쥯ȥ
	{
		// ǥ쥯ȥȸ
		debug_log_output("'%s' is Dir!!");
		return ( 1 ) ;
	}
	else
	{
		debug_log_output("stat() error\n", result);

		// -------------------------------------
		// File Not Found.
		// ˡdocument_root˶ư
		// -------------------------------------
		strncpy(http_recv_info_p->recv_uri,	"/",	sizeof(http_recv_info_p->recv_uri));
		strncpy(http_recv_info_p->send_filename, global_param.document_root, sizeof(http_recv_info_p->send_filename));
		// ǥ쥯ȥȰ	(ۥȤϤ⤦٥å٤ʤ)
		return ( 1 ) ;
	}


	return ( 1 );

}

