// ==========================================================================
//code=EUC	tab=4
//
// wizd:	MediaWiz Server daemon.
//
// 		wizd_listen.c
//											$Revision: 1.9 $
//											$Date: 2003/09/06 07:03:50 $
//
//	٤ƼǤǤʤޤġ
//  ΥեȤˤĤVertexLink䤤碌ʤǤ
// ==========================================================================

#include <ctype.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <memory.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/wait.h>
#include <netinet/in.h>
#include <signal.h>
#include <arpa/inet.h>

#include "wizd.h"




// **********************************************************************
// HTTP Ԥư
// **********************************************************************
void	server_listen()
{
    int    ret;
    int    pid;

	int		listen_socket;	// ԤSocket
    int		accept_socket;	// ³Socket

    struct sockaddr_in    saddr;		// Хåȥɥ쥹¤
    struct sockaddr_in    caddr;		// 饤ȥåȥɥ쥹¤
    int    caddr_len = sizeof(caddr);	// 饤ȥåȥɥ쥹¤ΤΥ

	int		sock_opt_val;


    // =============================
    // listenå
    // =============================
    listen_socket = socket(AF_INET, SOCK_STREAM, 0);
    if ( listen_socket < 0 ) // åԥå
    {
		perror("socket");
		exit( 1 );
    }

	// ===============================
	// SO_REUSEADDR򥽥åȤ˥å
	// ===============================
	sock_opt_val = 1;
	setsockopt(listen_socket, SOL_SOCKET, SO_REUSEADDR, (char *)&sock_opt_val, sizeof(sock_opt_val));

    // ===========================================
    // åȥɥ쥹¤Τͤ򥻥å
    // ===========================================
	memset( (char *)&saddr, 0, sizeof(saddr) );
    saddr.sin_family = AF_INET;
    saddr.sin_addr.s_addr = htonl(INADDR_ANY);
    saddr.sin_port = htons(global_param.server_port);

    // =============================
    // bind ¹
    // =============================
    ret = bind(listen_socket, (struct sockaddr *)&saddr, sizeof(saddr));
    if ( ret < 0 ) // bind ԥå
    {
		debug_log_output("bind() error. ret=%d\n", ret);
		perror("bind");
		return;
    }

    // =============================
    // listen¹
    // =============================
    ret = listen(listen_socket, LISTEN_BACKLOG);
    if ( ret < 0 )  // listenԥå
    {
		debug_log_output("listen() error. ret=%d\n", ret);
		perror("listen");
		return;
    }

	// =====================
	// ᥤ롼
	// =====================
    while ( 1 )
    {
    	// ----------------
    	// AcceptԤ.
    	// ----------------
		accept_socket = accept(listen_socket, (struct sockaddr *)&caddr, &caddr_len);
		if ( accept_socket < 0 ) // acceptԥå
		{
		    printf("accept() error. ret=%d\n", accept_socket);
		    perror("accept");
		    continue;		// ǽ롣
		}
		debug_log_output("\n\n=============================================================\n");
		debug_log_output("Socket Accept!!(accept_socket=%d)\n", accept_socket);

		// ========================
		// fork¹
		// ========================
		pid = fork(); 
		if ( pid < 0 ) // forkԥå
		{
		    printf("fork() error. ret=%d\n", pid);
			close(accept_socket);	// ǰåȤĤ롣
		    continue;				// ǽ롣
		} 

		if (pid == 0) 
		{
			// ʲҥץ
			debug_log_output("fork success!!(pid=%d)\n", pid);

		    // listen_socketĤ롣
		    close(listen_socket);	


			// caddr ɽ
			debug_log_output("client addr = %s\n", inet_ntoa(caddr.sin_addr) );
			debug_log_output("client port = %d\n", ntohs(caddr.sin_port) );




			// HTTPȤơŻ¹
			server_http_process(accept_socket);

			debug_log_output("HTTP process end.\n");
			debug_log_output("=============================================================\n");

	    	exit( 0 ); // ҥץｪλ
		}

		// ƥץaccept_socketĤ
		close(accept_socket);
    }


	return;
}

