// ==========================================================================
//code=EUC	tab=4
//
// wizd:	MediaWiz Server daemon.
//
// 		wizd_main.c
//											$Revision: 1.9 $
//											$Date: 2003/09/07 06:46:23 $
//
//	٤ƼǤǤʤޤġ
//  ΥեȤˤĤVertexLink䤤碌ʤǤ
// ==========================================================================
#include 	<stdio.h>
#include 	<string.h>
#include 	<stdlib.h>
#include	<unistd.h>
#include 	<signal.h>

#include	<sys/types.h>
#include 	<sys/wait.h>

#include "wizd.h"


static void print_help(void);
static void daemon_init(void);


static void setup_SIGCHLD(void);
static void catch_SIGCHLD(int signo);


// **************************************************************************
// * Main Program
// **************************************************************************
int main(int argc, char *argv[])
{
	int i;
	pid_t	pid;

	printf("%s  start.\n", SERVER_NAME);

	// =============================================
	// Ƽ
	// =============================================
	global_param_init();


	// =============================================
	// ץå
	// =============================================
	for (i=1; i<argc; i++)
	{

		// ----------------------------------------------------
		// -h, --help, -v, --version:  إץå
		// ----------------------------------------------------
		if ( (strcmp(argv[i], "-h") 		== 0) ||
			 (strcmp(argv[i], "--help")		== 0) ||
			 (strcmp(argv[i], "-v") 		== 0) ||
			 (strcmp(argv[i], "--version")	== 0) 		)
		{
			print_help();
			exit( 0 );
		}
	}





	// =============================================
	// եեɤ(wizd.conf)
	// =============================================
	config_file_read();


	// =======================
	// Debug Log ϳ
	// =======================
	if ( global_param.flag_debug_log_output == TRUE ) 
	{
		printf("debug log output start..\n");
		debug_log_initialize(global_param.debug_log_filename);
		debug_log_output("\n%s boot up.", SERVER_NAME );
		debug_log_output("debug log output start..\n");
	}


	// =================
	// daemon롣
	// =================
	if ( global_param.flag_daemon == TRUE )
	{
		printf("Daemoning....\n");
		daemon_init();
	}



	// ==========================================
	// ҥץʥforkɬ
	// ==========================================
	setup_SIGCHLD();


	// ==================================
	// ServerưФȤФ
	// Server DetectForkƼ¹
	// ==================================
	if ( global_param.flag_auto_detect == TRUE )
	{
		pid = fork(); 
		if ( pid < 0 ) // forkԥå
		{
		    perror("fork");
		    exit( 1 );
		} 

		if (pid == 0) 
		{
			// ʲҥץ
			server_detect();
			exit ( 0 );
		}
	}


	// =======================
	// HTTP ServerŻ
	// =======================
	server_listen();

	printf("%s  end.\n", SERVER_NAME);

	exit( 0 );
}





// **************************************************************************
// Helpå
// **************************************************************************
static void print_help(void)
{
	printf("%s -- %s\n\n", SERVER_NAME, SERVER_DETAIL);
	printf("Usase: wizd [options]\n");
	
	
	printf("Options:\n");
	printf(" -h, --help\tprint this message.\n");

	printf("\n");
}




// **************************************************************************
// ǡ󲽤롣
// **************************************************************************
static void daemon_init(void)
{
	int	pid;

	// ɸϡɸ२顼ϤĤ
	fclose(stdin);
	fclose(stdout);
	fclose(stderr);


	pid = fork() ;
	if ( pid != 0 )
	{
		exit ( 0 );
	}


	setsid();			
	signal(SIGHUP, SIG_IGN);

	pid = fork();
	if ( pid != 0 )
	{
		exit ( 0 );
	}


	return;
}






// **************************************************************************
// ҥץλȤ˥ʥ
// **************************************************************************
static void setup_SIGCHLD(void)
{
	struct sigaction act;
	memset(&act, 0, sizeof(act));   

	// SIGCHLDȯcatch_SIGCHLD()¹
	act.sa_handler = catch_SIGCHLD; 

	// catch_SIGCHLD()ɲåʥޥʤ
	sigemptyset(&act.sa_mask);  
	act.sa_flags = SA_NOCLDSTOP | SA_RESTART;
	sigaction(SIGCHLD, &act, NULL);

	return;
}


// **************************************************************************
// ʥưSIGCHLDȸƤФ롣
// **************************************************************************
static void catch_SIGCHLD(int signo)
{
	pid_t child_pid = 0;
	int child_ret;

	debug_log_output("catch SIGCHLD!!(signo=%d)\n", signo);


	// ٤ƤνλƤҥץФwaitpid()Ƥ
	while ( 1 )
	{
		child_pid = waitpid(-1, &child_ret, WNOHANG);
		debug_log_output("catch_SIGCHILD waitpid()=%d\n", child_pid);
		if (child_pid <= 0 )	// waitpidȡ-1
		{
			break;
		}
	}
	debug_log_output("catch SIGCHLD end.\n");


	return;
}



