// ==========================================================================
//code=EUC	tab=4
//
// wizd:	MediaWiz Server daemon.
//
// 		wizd_menu.c
//											$Revision: 1.4 $
//											$Date: 2003/09/07 10:40:18 $
//
//	٤ƼǤǤʤޤġ
//  ΥեȤˤĤVertexLink䤤碌ʤǤ
// ==========================================================================
#include <ctype.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <memory.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/stat.h>
#include <unistd.h>
#include <netinet/in.h>
#include <dirent.h>


#include "wizd.h"


typedef struct {
	unsigned char	name[255];			// ե̾
	mode_t			type;			// 
	off_t			size;			// 
	time_t			time;			// 
} FILE_INFO_T;



static int count_file_num(unsigned char *path);
static int directory_stat(unsigned char *path, FILE_INFO_T *file_info_p, int file_num);

static int file_ignoral_check(unsigned char *name);

static void http_filemenu_send(int accept_socket, unsigned char *filemenu_data);
static void file_info_sort_name_up(FILE_INFO_T *file_info_p, int file_num);
static void swap_file_info(FILE_INFO_T *file_info_1, FILE_INFO_T *file_info_2);

static void create_system_filemenu(HTTP_RECV_INFO *http_recv_info_p, FILE_INFO_T *file_info_p, int file_num, unsigned char *send_filemenu_buf, int buf_size);

// **************************************************************************
// եꥹȤֿ
// **************************************************************************
void http_menu(int accept_socket, HTTP_RECV_INFO *http_recv_info_p)
{
	unsigned char	send_filemenu_buf[1024*8];
//	int		i;

	int				file_num;	// DIRΥե
	unsigned char	*file_info_malloc_p;
	FILE_INFO_T		*file_info_p;


	// recv_uri κǸ夬'/'Ǥʤä顢'/'ɲ
	if (( strlen(http_recv_info_p->recv_uri) > 0 ) &&
		( http_recv_info_p->recv_uri[strlen(http_recv_info_p->recv_uri)-1] != '/' ))
	{
		strncat(http_recv_info_p->recv_uri, "/", sizeof(http_recv_info_p->recv_uri));
	}


	//  http_recv_info_p->send_filename κǸ夬'/'Ǥʤä顢'/'ɲ
	if (( strlen(http_recv_info_p->send_filename) > 0 ) &&
		( http_recv_info_p->send_filename[strlen(http_recv_info_p->send_filename)-1] != '/' ))
	{
		strncat(http_recv_info_p->send_filename, "/", sizeof(http_recv_info_p->send_filename));
	}



	// ==================================
	// ǥ쥯ȥǣţ
	// ==================================

	// recv_uri ǥ쥯ȥΥե롣
	file_num = count_file_num( http_recv_info_p->send_filename );
	debug_log_output("file_num = %d", file_num);
	if ( file_num < 0 )
	{
		return;
	}


	// ɬפʿե¸ꥢmalloc()
	file_info_malloc_p = malloc( sizeof(FILE_INFO_T)*file_num );
	if ( file_info_malloc_p == NULL )
	{
		debug_log_output("malloc() error");
		return;
	}


	memset(file_info_malloc_p, 0, sizeof(FILE_INFO_T)*file_num);

	file_info_p = (FILE_INFO_T *)file_info_malloc_p;

	// ե¸ꥢ˾ɤ߹ࡣ
	directory_stat(http_recv_info_p->send_filename, file_info_p, file_num);


	// ǥХåfile_info_malloc_p ɽ
	//for ( i=0; i<file_num; i++ )
	//{
	//	debug_log_output("file_info[%d] name='%s'", i, file_info_p[i].name );
	//	debug_log_output("file_info[%d] size='%d'", i, file_info_p[i].size );
	//	debug_log_output("file_info[%d] time='%d'", i, file_info_p[i].time );
	//}




	// ɬפʤСȼ¹
	if ( global_param.sort_rule == SORT_NAME_UP ) // ΤȤ̾Τߡ
	{
		file_info_sort_name_up(file_info_p, file_num);
	}
	
	
	//for ( i=0; i<file_num; i++ )
	//{
	//	debug_log_output("file_info[%d] name='%s'", i, file_info_p[i].name );
	//}


	// ===========================================
	// Ȥʤե˥塼
	// ===========================================
	create_system_filemenu(http_recv_info_p, file_info_p, file_num, send_filemenu_buf, sizeof(send_filemenu_buf) );


	debug_log_output("%s", send_filemenu_buf);
	debug_log_output("send_filemenu_size=%d", strlen(send_filemenu_buf)) ;



	// =================
	// ֿ¹
	// =================
	http_filemenu_send(accept_socket, send_filemenu_buf);



	free(file_info_malloc_p);

	return;
}




// **************************************************************************
// Ȥʤե˥塼
// **************************************************************************
static void create_system_filemenu(HTTP_RECV_INFO *http_recv_info_p, FILE_INFO_T *file_info_p, int file_num, unsigned char *send_filemenu_buf, int buf_size)
{

	unsigned char	work_buf[1024];
	unsigned char	ajdust_language_code[FILENAME_MAX];

	int		i, j;

	unsigned char	file_extension[FILENAME_MAX];
	int				file_type;
	unsigned char	rename_filename[FILENAME_MAX];	// ĥҽ񤭴
	unsigned char	parent_directory[FILENAME_MAX];	// ƥǥ쥯ȥ
	unsigned char	file_timestamp[32];
	unsigned char	unit_string[32];
	

	int		now_page;		// ߤΥڡֹ
	int		max_page;		// ڡֹ
	int		now_page_line;	// ߤΥڡɽԿ
	int		start_file_num;	// ߥڡɽϥեֹ

	int		next_page;		// Υڡ(̵-1)
	int		prev_page;		// Υڡ̵-1)




	// ==========================================
	// HTML Ƽ׻
	// ==========================================

	// ǥ쥯ȥ¸ߥե
	debug_log_output("file_num = %d", file_num);

	// ڡ׻
	max_page = (file_num / global_param.page_line_max) + 1;
	debug_log_output("max_page = %d", max_page);

	// ɽڡֹ ׻
	if ( (http_recv_info_p->page <= 1 ) || (max_page < http_recv_info_p->page ) )
		now_page = 1;
	else
		now_page = http_recv_info_p->page;

	debug_log_output("now_page = %d", now_page);

	// ɽڡɽԿ׻
	if ( max_page == now_page ) // ǸΥڡ
		now_page_line = file_num - (global_param.page_line_max * (max_page-1));
	else	// Ǹʳʤ顢ɽ
		now_page_line = global_param.page_line_max;
	debug_log_output("now_page_line = %d", now_page_line);


	// ɽϥեֹ׻
	start_file_num = ((now_page - 1) * global_param.page_line_max);
	debug_log_output("start_file_num = %d", start_file_num);

	// ڡֹ ׻
	prev_page =  1 ;
	if ( now_page > 1 )
		prev_page = now_page - 1;

	// ڡֹ ׻
	next_page = max_page ;
	if ( max_page > now_page )
		next_page = now_page + 1;

	debug_log_output("prev_page=%d  next_page=&d", prev_page ,next_page);


	// ľΥǥ쥯ȥѥ(ƥѥ)
	strncpy(parent_directory, http_recv_info_p->recv_uri, sizeof(parent_directory) );
	cut_after_last_character(parent_directory, '/'); // 
	cut_after_last_character(parent_directory, '/');
	strncat(parent_directory, "/", sizeof(parent_directory)); // Ǹ'/'ɲá

	debug_log_output("parent_directory='%s'", parent_directory);



	// =====================
	// HTML إå
	// =====================
	memset(send_filemenu_buf, '\0', buf_size);

	// ߥѥ̾ ʸѴ
	nkf(http_recv_info_p->recv_uri, ajdust_language_code, sizeof(ajdust_language_code), global_param.client_language_code);
	debug_log_output("adjust_dir = '%s'", ajdust_language_code );

	// 
	strncpy(send_filemenu_buf, "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 3.2 Final//EN\">\n<html><head>\n", buf_size );
	snprintf(work_buf, sizeof(work_buf), "<title>%s - %s</title>\n", ajdust_language_code, SERVER_NAME );
	strncat(send_filemenu_buf, work_buf, buf_size );
	strncat(send_filemenu_buf, "<meta SYABAS-COMPACT=OFF> <meta SYABAS-FULLSCREEN></head>\n", buf_size );


	// ======================
	// HTML BODY 
	// ======================

	strncat(send_filemenu_buf, "<body marginheight=0 marginwidth=0 leftmargin=0 topmargin=0 border=0 bgcolor=\"#CCCCCC\">\n", buf_size );


	// ߥǥ쥯ȥ
	strncat(send_filemenu_buf, "<table width=\"100%%\" cellspacing=0 cellpadding=0 border=0>\n<tr><td colspan=3>\n", buf_size );
	snprintf(work_buf, sizeof(work_buf), "<b>%s</b>\n</td>\n", ajdust_language_code );

	strncat(send_filemenu_buf, work_buf, buf_size );




	// allplay
	//strncat(send_filemenu_buf, "<td colspan=2 align=\"right\">\n", buf_size );
	//snprintf(work_buf, sizeof(work_buf), "<a href=\"%s?page=%d&action=allplay\" vod=\"playlist\" tvid=\"blue\"></a>\n", http_recv_info_p->recv_uri, now_page );
	//strncat(send_filemenu_buf, work_buf, buf_size );
	//snprintf(work_buf, sizeof(work_buf), "<a href=\"%s?page=%d&action=allplay\" vod=\"playlist\">allplay</a></td>\n", http_recv_info_p->recv_uri, now_page );
	//strncat(send_filemenu_buf, work_buf, buf_size );



	// ƥѥʸѴ
	nkf(parent_directory, ajdust_language_code, sizeof(ajdust_language_code), global_param.client_language_code);
	debug_log_output("adjust_dir = '%s'", ajdust_language_code );

	// ƥѥHTML
	snprintf(work_buf, sizeof(work_buf), "<tr><td><a href=\"%s\" tvid=\"yellow\"></a>[<a href=\"%s\" tvid=999>parent dir</a>]</td>\n", parent_directory , parent_directory );
	strncat(send_filemenu_buf, work_buf, buf_size );

	// ѥǥ
	strncat(send_filemenu_buf, "<td></td>", buf_size );

	// ڡ	
	snprintf(work_buf, sizeof(work_buf), "<td align=right><a href=\"%s?page=%d\" tvid=\"red\">&lt;&lt;</a>\n", http_recv_info_p->recv_uri, prev_page );
	strncat(send_filemenu_buf, work_buf, buf_size );

	// ڡ
	snprintf(work_buf, sizeof(work_buf), " %d/%d ", now_page, max_page );
	strncat(send_filemenu_buf, work_buf, buf_size );

	// ڡ
	snprintf(work_buf, sizeof(work_buf), "<a href=\"%s?page=%d\" tvid=\"green\">&gt;&gt;</a><br></td></tr>\n", http_recv_info_p->recv_uri, next_page);
	strncat(send_filemenu_buf, work_buf, buf_size );

	strncat(send_filemenu_buf, "</table>\n", buf_size );



	strncat(send_filemenu_buf, "<table width=\"100%%\" cellspacing=0 cellpadding=0 border=0>\n", buf_size );
	// =================================
	// եꥹ
	// Ȥǡڡ롣
	// =================================
	for ( i=start_file_num; i<(start_file_num + now_page_line) ; i++ )
	{
		// ɽȥʸѴ
		nkf(file_info_p[i].name, ajdust_language_code, sizeof(ajdust_language_code), global_param.client_language_code);
		debug_log_output("ajdust_language_code='%s'\n", ajdust_language_code);

		// ե뤬ȥ꡼फʳå
		memset(file_extension, '\0', sizeof(file_extension));


		// -------------------------------------------
		// եˤꡢ˥塼
		//	NORMAL_FILE / STREAM_FILE / SVI_FILE / DIR ʬ롣
		// ޤ̤
		// -------------------------------------------
		strncpy(file_extension, file_info_p[i].name, sizeof(file_extension));
		cut_before_last_character(file_extension, '.');
		debug_log_output("file_extension='%s'\n", file_extension);

		// ---------------------------
		// ե륿Ƚ
		// ---------------------------

		// ǥ쥯ȥ꤫
		if ( S_ISDIR( file_info_p[i].type ) != 0 )
		{
			file_type = TYPE_DIRECTORY;
		}
		else 
		{
			file_type = TYPE_NORMAL_FILE;
			for (j=0;;j++)
			{
				if (( mime_list[j].mime_name == NULL ) || ( strlen(file_extension) == 0 ) )
				{
					break;
				}
				if ( strcasecmp(mime_list[j].file_extension, file_extension) == 0 )
				{
					file_type = mime_list[j].file_type;
					break;
				}
			}
			debug_log_output("file_type=%d\n", file_type );
		}

		snprintf(work_buf, sizeof(work_buf), "<tr>\n<td width=100 valign=\"top\"></td>\n<td valign=\"top\" align=center>%d</td>\n<td valign=\"top\">", i+1 );
		strncat(send_filemenu_buf, work_buf, buf_size);

		// ե륹פʸ
		conv_time_to_string(file_timestamp, file_info_p[i].time );

		// ---------------------------
		// ե륿פˤꡢʬ
		// ---------------------------
		if ( file_type == TYPE_STREAM_FILE )
		{
			// -----------------------------
			// ȥ꡼ξ硣
			// -----------------------------

			// ե륵ɽ
			conv_num_to_unit_string(unit_string, file_info_p[i].size );
#ifndef __APPLE__
		  	debug_log_output("%d = %s\n", file_info_p[i].size, unit_string);
#endif

			// ĥ֤
			strncpy( rename_filename, file_info_p[i].name, sizeof(rename_filename));

			extension_add_rename(rename_filename);

			snprintf(work_buf, sizeof(work_buf), "<a href=\"%s%s\" vod=\"0\" tvid=\"%d\">%s</a> %s %s<br>\n", http_recv_info_p->recv_uri, rename_filename, i+1, ajdust_language_code, unit_string, file_timestamp );
			strncat(send_filemenu_buf, work_buf, buf_size);
		}
		else if (file_type == TYPE_NORMAL_FILE )
		{
			// -----------------------------
			// Ρޥեξ
			// -----------------------------
			// ե륵ɽ
			conv_num_to_unit_string(unit_string, file_info_p[i].size );
			debug_log_output("%d = '%s'", file_info_p[i].size, unit_string);

			snprintf(work_buf, sizeof(work_buf), "<a href=\"%s%s\" tvid=\"%d\">%s</a> %s %s<br>\n", http_recv_info_p->recv_uri, file_info_p[i].name, i+1, ajdust_language_code, unit_string, file_timestamp	);
			strncat(send_filemenu_buf, work_buf, buf_size);
		}
		else
		{
			// -----------------------------
			// ǥ쥯ȥξ硣
			// -----------------------------
			snprintf(work_buf, sizeof(work_buf), "<b>[</b><a href=\"%s%s\" tvid=\"%d\">%s</a><b>]</b> %s<br>\n", http_recv_info_p->recv_uri, file_info_p[i].name, i+1, ajdust_language_code, file_timestamp	);
			strncat(send_filemenu_buf, work_buf, buf_size);
		}

		strncat(send_filemenu_buf, "</td></tr>", buf_size);


	}

	strncat(send_filemenu_buf, "</table>", buf_size);

	// =====================
	// HTML եå
	// =====================

	strncat(send_filemenu_buf, "<div align=right>", buf_size );

	// ڡ	
	snprintf(work_buf, sizeof(work_buf), "<a href=\"%s?page=%d\" tvid=\"red\">&lt;&lt;</a>\n", http_recv_info_p->recv_uri, prev_page );
	strncat(send_filemenu_buf, work_buf, buf_size );

	// ڡ
	snprintf(work_buf, sizeof(work_buf), " %d/%d ", now_page, max_page );
	strncat(send_filemenu_buf, work_buf, buf_size );

	// ڡ
	snprintf(work_buf, sizeof(work_buf), "<a href=\"%s?page=%d\" tvid=\"green\">&gt;&gt;</a><br>\n", http_recv_info_p->recv_uri, next_page);
	strncat(send_filemenu_buf, work_buf, buf_size );

	strncat(send_filemenu_buf, "</div></body></html>", buf_size );
	return;
}



// **************************************************************************
// *path ǻꤵ줿ǥ쥯ȥ¸ߤե򥫥Ȥ
// 
// return: ե
// **************************************************************************
static int count_file_num(unsigned char *path)
{
	int		count;

	DIR	*dir;
	struct dirent	*dent;

	debug_log_output("count_file_num() start. path='%s'", path);

	dir = opendir(path);
	if ( dir == NULL )	// 顼å
	{
		debug_log_output("opendir() error");
		return ( -1 );
	}

	count = 0;
	while ( 1 )
	{
		dent = readdir(dir);
		if ( dent == NULL  )
			break;

		// ̵եå
		if ( file_ignoral_check(dent->d_name) != 0 )
			continue;

		count++;
	}

	closedir(dir);

	debug_log_output("count_file_num() end. counter=%d", count);
	return count;
}



// **************************************************************************
// ǥ쥯ȥ¸ߤ򡢥եοɤ߹ࡣ
//
// return: ɤ߹ե
// **************************************************************************
static int directory_stat(unsigned char *path, FILE_INFO_T *file_info_p, int file_num)
{
	int	count;
	DIR	*dir;
	struct dirent	*dent;
	struct stat		file_stat;
	int				result;
	unsigned char	fullpath_filename[FILENAME_MAX];


	debug_log_output("directory_stat() start. path='%s'", path);


	dir = opendir(path);
	if ( dir == NULL )	// 顼å
	{
		debug_log_output("opendir() error");
		return ( -1 );
	}

	debug_log_output("off_t = %d", sizeof(file_stat.st_size));
	debug_log_output("dent->d_name = %d", sizeof(dent->d_name));

	count = 0;
	while ( 1 ) 
	{
		if ( count >= file_num )
			break;

		// ǥ쥯ȥ꤫顢ե̾򣱸GET
		dent = readdir(dir);
		if ( dent == NULL  )
			break;

		// ̵եå
		if ( file_ignoral_check(dent->d_name) != 0 )
			continue;

//		debug_log_output("dent->d_name='%s'", dent->d_name);

		// ե̾¸
		strncpy(file_info_p[count].name, 		dent->d_name, sizeof(file_info_p[count].name) );

		strncpy(fullpath_filename, path, sizeof(fullpath_filename) );
		strncat(fullpath_filename, file_info_p[count].name, sizeof(fullpath_filename) );

//		debug_log_output("fullpath_filename='%s'", fullpath_filename );

		// stat¹
		memset(&file_stat, 0, sizeof(file_stat));
		result = stat(fullpath_filename, &file_stat);
//		debug_log_output("result=%d", result);
		if ( result >= 0 )
		{
			file_info_p[count].type = file_stat.st_mode;
			file_info_p[count].size = file_stat.st_size;
			file_info_p[count].time = file_stat.st_ctime;
		}

		count++;
	}
	closedir(dir);

	debug_log_output("directory_stat() end. count=%d", count);

	return count;
}


// ******************************************************************
// ե̵å
// ǥ쥯ȥǡե̵뤹뤫ʤȽǤ롣
// return: 0:OK  -1 ̵
// ******************************************************************
static int file_ignoral_check(unsigned char *name)
{
	
	// "."".."ϥåפ롣
	if ( strcmp(name , ".") == 0 )
		return ( -1 );

	if ( strcmp(name , "..") == 0 )
		return ( -1 );

	// "lost+found" ⥹å
	if ( strcmp(name , "lost+found") == 0 )
		return ( -1 );

#ifdef __APPLE__
	/* --- MacOSX "._" ǻϤޤեϥ꥽եʤΤǥå */
        if ((name[0] == '.') && (name[1] == '_')) {
	  return(-1);
	}
#endif

	return 0;
}







// **************************************************************************
// HTTP_OKإåơֿ¹
// **************************************************************************
static void http_filemenu_send(int accept_socket, unsigned char *filemenu_data)
{
	unsigned int	send_data_len;
	unsigned char	send_http_header_buf[1024];
	unsigned char	work_buf[1024];
	int	result_len;

	// --------------
	// OK إå
	// --------------
	memset(send_http_header_buf, '\0', sizeof(send_http_header_buf));

	strncpy(send_http_header_buf, HTTP_OK, sizeof(send_http_header_buf));
	strncat(send_http_header_buf, HTTP_CONNECTION, sizeof(send_http_header_buf));
	sprintf(work_buf, HTTP_CONTENT_TYPE, "text/html");
	strncat(send_http_header_buf, work_buf, sizeof(send_http_header_buf));
	sprintf(work_buf, HTTP_SERVER_NAME, SERVER_NAME);
	strncat(send_http_header_buf, work_buf, sizeof(send_http_header_buf));

	sprintf(work_buf, HTTP_CONTENT_LENGTH, strlen(filemenu_data) );
	strncat(send_http_header_buf, work_buf, sizeof(send_http_header_buf));

	strncat(send_http_header_buf, HTTP_END, sizeof(send_http_header_buf));


	send_data_len = strlen(send_http_header_buf);
	debug_log_output("header_send_data_len = %d\n", send_data_len);
	debug_log_output("--------\n");
	debug_log_output("%s", send_http_header_buf);
	debug_log_output("--------\n");


	// --------------
	// إåֿ
	// --------------
	result_len = send(accept_socket, send_http_header_buf, send_data_len, 0);
	debug_log_output("result_len=%d, send_data_len=%d\n", result_len, send_data_len);


	// --------------
	// ֿ
	// --------------
	send_data_len = strlen(filemenu_data);
	result_len = send(accept_socket, filemenu_data, send_data_len, 0);
	debug_log_output("result_len=%d, send_data_len=%d\n", result_len, send_data_len );

	return;
}






// **************************************************************************
// file_info_p Ƥ򡢥ե̾ǥȤ
// **************************************************************************
static void file_info_sort_name_up( FILE_INFO_T *file_info_p, int file_num)
{
	int i, j;



	// ǥ쥯ȥ־ˡ

	// ǥ쥯ȥ򡢥


	// ե륽ȼ¹
	for ( i=0; i<file_num; i++ )
	{
		for ( j=i+1; j<file_num; j++ )
		{
			if ( strcasecmp( file_info_p[i].name,  file_info_p[j].name ) > 0 )
			{
				swap_file_info( &file_info_p[i], &file_info_p[j] );
			}
		}
	}


	return;
}


// ===============================================
// file_info_1 ȡfile_info_2򥹥åפ롣
// ===============================================
static void swap_file_info(FILE_INFO_T *file_info_1, FILE_INFO_T *file_info_2)
{
	FILE_INFO_T		swap_area;

	memcpy( &swap_area	, file_info_1	, sizeof(FILE_INFO_T) );
	memcpy( file_info_1	, file_info_2	, sizeof(FILE_INFO_T) );
	memcpy( file_info_2	, &swap_area	, sizeof(FILE_INFO_T) );
	return;
}


