// ==========================================================================
//code=EUC	tab=4
//
// wizd:	MediaWiz Server daemon.
//
// 		wizd_param.c
//											$Revision: 1.10 $
//											$Date: 2003/09/06 18:57:10 $
//
//	٤ƼǤǤʤޤġ
//  ΥեȤˤĤVertexLink䤤碌ʤǤ
// ==========================================================================
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include "wizd.h"


static FILE *config_file_open(void);
static int config_file_read_line(FILE *fp, unsigned char *line_buf, int line_buf_size);


// ********************************************
// MIME ꥹ
// ȤꤢΤäƤ¤񤤤Ƥ
// ********************************************
MIME_LIST_T	mime_list[] = {
//  {mime_name			,file_extension	, 	file_type 			}
	{"text/plain"		,	"txt"		,	TYPE_NORMAL_FILE	},
	{"text/html"		, 	"htm"		,	TYPE_NORMAL_FILE	},
	{"text/html"		, 	"html"		,	TYPE_NORMAL_FILE	},
	{"image/gif"		, 	"gif"		,	TYPE_NORMAL_FILE	},
	{"image/jpeg"		, 	"jpeg"		,	TYPE_NORMAL_FILE	},
	{"image/jpeg"		, 	"jpg"		,	TYPE_NORMAL_FILE	},
	{"image/png"		,	"png"		,	TYPE_NORMAL_FILE	},
	{"video/mpeg"		, 	"mpeg"		,	TYPE_STREAM_FILE	},
	{"video/mpeg"		, 	"mpg"		,	TYPE_STREAM_FILE	},
	{"video/mpeg"		, 	"svi"		,	TYPE_STREAM_FILE	},
	{"video/mpeg"		, 	"m2p"		,	TYPE_STREAM_FILE	},
	{"video/msvideo"	, 	"avi"		,	TYPE_STREAM_FILE	},
	{"video/mpeg"		, 	"vob"		,	TYPE_STREAM_FILE	},
	{"video/quicktime"	,	"mov"		,	TYPE_STREAM_FILE	},
	{"video/x-ms-wmv"	,	"wmv"		,	TYPE_STREAM_FILE	},
	{"video/x-ms-wmx"	,	"asf"		,	TYPE_STREAM_FILE	},
	{"audio/x-mpeg"		, 	"mp3"		,	TYPE_STREAM_FILE	},
	{"audio/x-ogg"		, 	"ogg"		,	TYPE_STREAM_FILE	},
	{"audio/x-mpeg"		, 	"mp4"		,	TYPE_STREAM_FILE	},
	{"audio/x-ms-wma"	,	"wma"		, 	TYPE_STREAM_FILE	},
	{"audio/x-wav"		,	"wav"		,	TYPE_STREAM_FILE	},
	{"audio/ac3"		, 	"ac3"		,	TYPE_STREAM_FILE	},
	{NULL, NULL, (-1)}
};



// ********************************************
// ĥѴꥹ
// ********************************************
EXTENSION_CONVERT_LIST_T extension_convert_list[] = {
//	{org_extension	,	rename_extension	}
	{"m2p"			,	"m2p.mpg"			},
	{"svi"			,	"svi.mpg"			},
	{ NULL, NULL }
};




// ********************************************
// Υѥ᡼¤Τμ
// ********************************************
GLOBAL_PARAM_T	global_param;


// ********************************************
// Υѥ᡼¤Τν
// ǥեͤ򥻥å
// ********************************************
void global_param_init(void)
{
	memset(&global_param, 0, sizeof(global_param));

	// ǡ󲽥ե饰
	global_param.flag_daemon 		= DEFAULT_FLAG_DAEMON;

	// ư
	global_param.flag_auto_detect 	= DEFAULT_FLAG_AUTO_DETECT;

	// ǥեServer̾
	strncpy(global_param.server_name, DEFAULT_SERVER_NAME, sizeof(global_param.server_name));

	// ǥեHTTP ԤPort.
	global_param.server_port 		= DEFAULT_SERVER_PORT;

	// Document Root
	strncpy(global_param.document_root, DEFAULT_DOCUMENT_ROOT, sizeof(global_param.document_root));

	// DebugLog
	global_param.flag_debug_log_output = DEFAULT_FLAG_DEBUG_LOG_OUTPUT;
	strncpy(global_param.debug_log_filename, DEFAULT_DEBUG_LOG_FILENAME, sizeof(global_param.debug_log_filename));

	// MediaWizθ쥳
	strncpy(global_param.client_language_code, DEFAULT_CLIENT_LANGUAGE_CODE, sizeof(global_param.client_language_code));

	// ѥե饰
	global_param.flag_use_skin 		= DEFAULT_FLAG_USE_SKIN;
	
	// ֤
	strncpy(global_param.skin_root, DEFAULT_SKINDATA_ROOT, sizeof(global_param.skin_root));

	// ̾
	strncpy(global_param.skin_name, DEFAULT_SKINDATA_NAME, sizeof(global_param.skin_name));

	// ե륽ȤΥ롼
	global_param.sort_rule	= DEFAULT_SORT_RULE;

	// ڡɽԿ
	global_param.page_line_max	= DEFAULT_PAGE_LINE_MAX;


	return;
}





// ****************************************************
// wizd_conf ɤ
// ****************************************************
void config_file_read(void)
{
	FILE	*fp;
	unsigned char	line_buf[1024*4];
	int	ret;

	unsigned char	key[1024];
	unsigned char	value[1024];


	// =======================
	// ConfigեOPEN
	// =======================
	fp = config_file_open();
	if ( fp == NULL )
		return;


	// =====================
	// ɤ߹
	// =====================
	while ( 1 ) 
	{
		// ɤࡣ
		ret = config_file_read_line(fp, line_buf, sizeof(line_buf));

		if ( ret < 0 )
		{
			printf("EOF Detect.\n");
			break;
		}

		// '#'
		cut_after_character(line_buf, '#');
		// '\t'ŤʤäƤȤ
		duplex_character_to_unique(line_buf, '\t');
		// '\t'' 'ִ
		replase_character(line_buf, "\t", " ");
		// Ƭ' '
		cut_first_character(line_buf, ' ');

		// Ǹ ' '
		cut_character_at_linetail(line_buf, ' ');

		if ( strlen(line_buf) > 0 )	// ͤäƤ
		{
			// ' 'ǡʬ
			sentense_split(line_buf, ' ', key, value);
			printf("key='%s', value='%s'\n", key, value);

			// ---------------------
			// ͤɤߤȤ¹ԡ
			// ---------------------
			if (( strlen(key) > 0 ) && (strlen(value) > 0 ))
			{
				// flag_daemon
				if ( strcasecmp("flag_daemon", key) == 0 )
				{
					if (strcasecmp(value ,"true") == 0 )
						global_param.flag_daemon = TRUE;
					else if (strcasecmp(value ,"false") == 0 )
						global_param.flag_daemon = FALSE;
				}

				// flag_auto_detect
				if ( strcasecmp("flag_auto_detect", key) == 0 )
				{
					if (strcasecmp(value ,"true") == 0 )
						global_param.flag_auto_detect = TRUE;
					else if (strcasecmp(value ,"false") == 0 )
						global_param.flag_auto_detect = FALSE;
				}



				// flag_debug_log_output
				if ( strcasecmp("flag_debug_log_output", key) == 0 )
				{
					if (strcasecmp(value ,"true") == 0 )
						global_param.flag_debug_log_output = TRUE;
					else if (strcasecmp(value ,"false") == 0 )
						global_param.flag_debug_log_output = FALSE;
				}

				// debug_log_filename
				if ( strcasecmp("debug_log_filename", key) == 0 )
				{
					strncpy(global_param.debug_log_filename, value, sizeof(global_param.debug_log_filename));
				}

				// auto_detect_bind_ip_address
				if ( strcasecmp("auto_detect_bind_ip_address", key) == 0 )
				{
					strncpy(global_param.auto_detect_bind_ip_address, value, sizeof(global_param.auto_detect_bind_ip_address));
				}

				// server_name
				if ( strcasecmp("server_name", key) == 0 )
				{
					strncpy(global_param.server_name, value, sizeof(global_param.server_name));
				}


				// server_port
				if ( strcasecmp("server_port", key) == 0 )
				{
					global_param.server_port = atoi(value);
				}

				// document_root
				if ( strcasecmp("document_root", key) == 0 )
				{
					strncpy(global_param.document_root, value, sizeof(global_param.document_root));
				}

				// client_language_code
				if ( strcasecmp("client_language_code", key) == 0 )
				{
					if (strcasecmp(value ,"sjis") == 0 )
						strncpy(global_param.client_language_code, NKF_CODE_SJIS, sizeof(global_param.client_language_code) );
					else if (strcasecmp(value ,"euc") == 0 )
						strncpy(global_param.client_language_code, NKF_CODE_EUC, sizeof(global_param.client_language_code) );
				}

				// flag_use_skin
				if ( strcasecmp("flag_use_skin", key) == 0 )
				{
					if (strcasecmp(value ,"true") == 0 )
						global_param.flag_use_skin = TRUE;
					else if (strcasecmp(value ,"false") == 0 )
						global_param.flag_use_skin = FALSE;
				}

				// skin_root
				if ( strcasecmp("skin_root", key) == 0 )
				{
					strncpy(global_param.skin_root, value, sizeof(global_param.skin_root));
				}

				// skin_name
				if ( strcasecmp("skin_name", key) == 0 )
				{
					strncpy(global_param.skin_name, value, sizeof(global_param.skin_name));
				}

				// sort_rule
				
				if ( strcasecmp("sort_rule", key) == 0 )
				{
					if (strcasecmp(value ,"none") == 0 )
						global_param.sort_rule = SORT_NONE;
					else if (strcasecmp(value ,"name_up") == 0 )
						global_param.sort_rule = SORT_NAME_UP;
					else if (strcasecmp(value ,"name_down") == 0 )
						global_param.sort_rule = SORT_NAME_DOWN;
					else if (strcasecmp(value ,"time_up") == 0 )
						global_param.sort_rule = SORT_TIME_UP;
					else if (strcasecmp(value ,"time_down") == 0 )
						global_param.sort_rule = SORT_TIME_DOWN;
					else if (strcasecmp(value ,"size_up") == 0 )
						global_param.sort_rule = SORT_SIZE_UP;
					else if (strcasecmp(value ,"size_down") == 0 )
						global_param.sort_rule = SORT_SIZE_DOWN;
				}

				// server_port
				if ( strcasecmp("page_line_max", key) == 0 )
				{
					global_param.page_line_max = atoi(value);
				}



			}
		}
	}


	return;
}










// *****************************************************
// wizd.conf 飱ɤ߹
// ɤ߹ʸreturn롣
// Ǹޤɤ顢-1롣
// *****************************************************
static int config_file_read_line(FILE *fp, unsigned char *line_buf, int line_buf_size)
{
	int read_len;
	int	total_read_len;
	unsigned char	read_char;
	unsigned char *p;

	p = line_buf;
	total_read_len = 0;

	while ( 1 ) 
	{
		// ʸread.
		read_len  = fread(&read_char, 1, 1, fp);
		if ( read_len <= 0 ) // EOF
		{
			return ( -1 );
		}
		else if ( read_char == '\r' )
		{
			continue;
		}
		else if ( read_char == '\n' )
		{
			break;
		}

		*p = read_char;
		p++;
		total_read_len++;

		if ( total_read_len >= line_buf_size )
		{
			break;
		}
	}

	*p = '\0';
	return total_read_len;
}


// ****************************************************
// wizd_conf 򳫤
// ʤäNULL
// ****************************************************
static FILE *config_file_open(void)
{
	FILE *fp;

	fp = NULL;

	fp = fopen(DEFAULT_CONF_FILENAME1, "r");
	if ( fp != NULL )
	{
		printf("config '%s' open.\n", DEFAULT_CONF_FILENAME1);
		return ( fp );
	}

	fp = fopen(DEFAULT_CONF_FILENAME2, "r");
	if ( fp != NULL )
	{
		printf("config '%s' open.\n", DEFAULT_CONF_FILENAME2);
		return ( fp );
	}

	fp = fopen(DEFAULT_CONF_FILENAME3, "r");
	if ( fp != NULL )
	{
		printf("config '%s' open.\n", DEFAULT_CONF_FILENAME3);
		return ( fp );
	}


	return NULL ;
}

