// ==========================================================================
//code=EUC	tab=4
//
// wizd:	MediaWiz Server daemon.
//
// 		wizd_send_file.c
//											$Revision: 1.2 $
//											$Date: 2003/09/06 18:57:10 $
//
//	٤ƼǤǤʤޤġ
//  ΥեȤˤĤVertexLink䤤碌ʤǤ
// ==========================================================================
#include <ctype.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <memory.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/stat.h>
#include <unistd.h>
#include <netinet/in.h>
#include <dirent.h>


#include "wizd.h"



static int http_file_send(int accept_socket, unsigned char *filename, unsigned int content_length, unsigned int range_start_pos );


// **************************************************************************
// եΤֿ
// إå
// **************************************************************************
int http_file_response(int accept_socket, HTTP_RECV_INFO *http_recv_info_p)
{
	int	send_data_len;
	int	result_len;

	unsigned char	send_http_header_buf[2048];
	unsigned char	work_buf[1024];


	// ---------------
	// ѿ
	// ---------------
	memset(send_http_header_buf, '\0', sizeof(send_http_header_buf));

	// --------------
	// OK إå
	// --------------
	strncpy(send_http_header_buf, HTTP_OK, sizeof(send_http_header_buf));

	strncat(send_http_header_buf, HTTP_CONNECTION, sizeof(send_http_header_buf));

	sprintf(work_buf, HTTP_SERVER_NAME, SERVER_NAME);
	strncat(send_http_header_buf, work_buf, sizeof(send_http_header_buf));

	sprintf(work_buf, HTTP_CONTENT_LENGTH, http_recv_info_p->content_length);
	strncat(send_http_header_buf, work_buf, sizeof(send_http_header_buf));

	sprintf(work_buf, HTTP_CONTENT_TYPE, http_recv_info_p->mime_type);
	strncat(send_http_header_buf, work_buf, sizeof(send_http_header_buf));
	strncat(send_http_header_buf, HTTP_END, sizeof(send_http_header_buf));






	send_data_len = strlen(send_http_header_buf);
	debug_log_output("send_data_len = %d\n", send_data_len);
	debug_log_output("--------\n");
	debug_log_output("%s", send_http_header_buf);
	debug_log_output("--------\n");


	// --------------
	// إåֿ
	// --------------
	result_len = send(accept_socket, send_http_header_buf, send_data_len, 0);
	debug_log_output("result_len=%d, send_data_len=%d\n", result_len, send_data_len);


	// --------------
	// ֿ
	// --------------
	http_file_send(	accept_socket, 	http_recv_info_p->send_filename, 
									http_recv_info_p->content_length,
									http_recv_info_p->range_start_pos );



	return 0;
}





// **************************************************************************
// եμΤ¹
// **************************************************************************
static int http_file_send(int accept_socket, unsigned char *filename, unsigned int content_length, unsigned int range_start_pos )
{
	FILE *fp;

	unsigned char 	*send_buf_p;

	int				file_read_len;
	int				data_send_len;
	int				ret;

	unsigned int	total_read_size;
	unsigned int	target_read_size;


	// ======================
	// Хåե
	// ======================

	send_buf_p = malloc(SEND_BUFFER_SIZE);
	if ( send_buf_p == NULL )
	{
		debug_log_output("malloc() error.\n");
		return (-1 );
	}

	// ---------------------
	// ե륪ץ
	// ---------------------
	fp = fopen(filename, "rb");
	if ( fp == NULL )
	{	
		debug_log_output("fopen() error.");
		free(send_buf_p);
		return ( -1 );
	}


	// ------------------------------------------
	// range_start_posإե륷
	// ------------------------------------------
	ret = fseek(fp, range_start_pos, SEEK_SET);
	if ( ret < 0 )	// fseek 顼å
	{	
		debug_log_output("fseek() error.");
		free(send_buf_p);
		fclose(fp);
		return ( -1 );
	}


	total_read_size = 0;

	// ================
	// ž
	// ================
	while ( 1 )
	{
		// Хåեꥢ
		memset(send_buf_p, 0, SEND_BUFFER_SIZE);

		// ɸread׻
		target_read_size = (content_length - total_read_size);
		if ( target_read_size > SEND_BUFFER_SIZE )
		{
			target_read_size = SEND_BUFFER_SIZE;
		}

		// ե뤫ǡɤ߹ࡣ
		file_read_len = fread(send_buf_p, 1, target_read_size, fp);
		if ( file_read_len <= 0 )
		{
			debug_log_output("EOF detect.\n");
			break;
		}



		// SOCKET ˥ǡ
		data_send_len = send(accept_socket, send_buf_p, file_read_len, 0);
		//debug_log_output("data_send_len=%d, send_data_len=%d\n", data_send_len, file_read_len);
		if ( data_send_len != file_read_len ) 
		{
			debug_log_output("send() error.\n");
			fclose(fp);	// File Close.
			return ( -1 );
		}

		total_read_size += file_read_len;
		if ( content_length != 0 )
		{
			debug_log_output("Streaming..  %d / %d ( %4.1f%% )\n", total_read_size, content_length, (double)total_read_size * 100.0/(double)content_length );
		}
		if ( total_read_size >= content_length)
		{
			debug_log_output("send() end.(content_length=%d)\n", content_length );
		}


	}

	free(send_buf_p);	// Memory Free.
	fclose(fp);	// File Close.

	// ｪλ
	return 0;
}











