// ==========================================================================
//code=EUC	tab=4
//
// wizd:	MediaWiz Server daemon.
//
// 		wizd_tools.c
//											$Revision: 1.12 $
//											$Date: 2003/09/07 11:11:10 $
//
//	٤ƼǤǤʤޤġ
//  ΥեȤˤĤVertexLink䤤碌ʤǤ
// ==========================================================================
#include        <sys/types.h>

#include        <stdio.h>
#include		<stdlib.h>
#include 		<stdarg.h>
#include		<string.h>
#include		<limits.h>
#include 		<time.h>
#include 		<sys/stat.h>
#include        <errno.h>

#include		"wizd.h"
#include		"wizd_tools.h"


static unsigned char		debug_log_filename[FILENAME_MAX];	// ǥХåϥե̾(եѥ)
static unsigned char		debug_log_initialize_flag  = (-1);	// ǥХåե饰

static void output_log_rotate(const char *target_filename);


/********************************************************************************/
// sentenceʸkeyʸrepʸִ롣
/********************************************************************************/
void replase_character(unsigned char *sentence, const unsigned char *key, const unsigned char *rep)
{
	unsigned char	*p, buf[4098];

	p = strstr(sentence, key);

	while (p != NULL)
	{
		*p = '\0';
		strncpy(buf, p+strlen(key), sizeof(buf) );
		strncat(sentence, rep, sizeof(buf) - strlen(sentence) - 1 );
		strncat(sentence, buf, sizeof(buf) - strlen(sentence) - 1 );
		p = strstr(p+strlen(rep), key);
	}

	return;
}

//***************************************************************************
// sentenseʸꡢcut_char
//	Ĥʤв⤷ʤ
//***************************************************************************
void 	cut_after_character(unsigned char *sentense, unsigned char cut_char)
{
	unsigned char 	*symbol_p;

	// оݥ饯ä硢줫
	symbol_p = strchr(sentense, cut_char);

	if (symbol_p != NULL)
	{
		*symbol_p = '\0';
	}

	return;
}



//***************************************************************************
// sentenseʸΡcut_charǽ˽ФƤ꤫
// ⤷cut_charsentenseʸäƤʤä硢ʸ
//***************************************************************************
void 	cut_before_character(unsigned char *sentense, unsigned char cut_char)
{

	unsigned char 	*symbol_p;
	unsigned char	*malloc_p;

	if (sentense == NULL)
		return;

	// оݥ饯ǽ˽ФƤõ
	symbol_p = strchr(sentense, cut_char);
	if (symbol_p == NULL)
	{
		// ȯǤʤä硢ʸ
		strcpy(sentense, "");
		return;
	}

	symbol_p++;

	// ƥݥꥨꥢmalloc.
	malloc_p = malloc(strlen(sentense) + 10);	
	if (malloc_p == NULL)
		return;

	// оݥ饯θǸޤǤʸ򥳥ԡ
	strcpy(malloc_p, symbol_p);

	// sentense񤭴
	strcpy(sentense, malloc_p);

	free(malloc_p);

	return;
}


//************************************************************************
// sentenseʸΡcut_charǸ˽ФƤ꤫
// ⤷cut_charsentenseʸäƤʤä硢ʤˤ⤷ʤ
//************************************************************************
void 	cut_before_last_character(unsigned char *sentense, unsigned char cut_char)
{

	unsigned char 	*symbol_p;
	unsigned char	*malloc_p;

	if (sentense == NULL)
		return;

	// оݥ饯Ǹ˽ФƤõ
	symbol_p = strrchr(sentense, cut_char);
	if (symbol_p == NULL)
	{
		// ȯǤʤä硢ʸ
		strcpy(sentense, "");
		return;
	}

	symbol_p++;

	// ƥݥꥨꥢmalloc.
	malloc_p = malloc(strlen(sentense) + 10);	
	if (malloc_p == NULL)
		return;

	// оݥ饯θǸޤǤʸ򥳥ԡ
	strcpy(malloc_p, symbol_p);

	// sentense񤭴
	strcpy(sentense, malloc_p);

	free(malloc_p);

	return;
}

//************************************************************************
// sentenseʸΡcut_charǸ˽ФƤ꤫CUT
// ⤷cut_charsentenseʸäƤʤä硢ʸ
//************************************************************************
void 	cut_after_last_character(unsigned char *sentense, unsigned char cut_char)
{

	unsigned char 	*symbol_p;

	if (sentense == NULL)
		return;

	// оݥ饯Ǹ˽ФƤõ
	symbol_p = strrchr(sentense, cut_char);
	if (symbol_p == NULL)
	{
		// ȯǤʤä硢ʸ
		strcpy(sentense, "");
		return;
	}

	*symbol_p = '\0';

	return;
}


//******************************************************************
// sentenseΡ n byteĤƺ
//******************************************************************
void 	cat_before_n_length(unsigned char *sentense,  unsigned int n)
{
	unsigned char	*malloc_p;
	unsigned char	*work_p;


	if (sentense == NULL)
		return;

	// sentense nƱûʤreturn
	if ( strlen(sentense) <= n )
		return;


	// ƥݥꥨꥢmalloc.
	malloc_p = malloc(strlen(sentense) + 10);	
	if (malloc_p == NULL)
		return;

	work_p = sentense;
	work_p += strlen(sentense);
	work_p -= n;
	strcpy(malloc_p, work_p);
	strcpy( sentense, malloc_p);

	free(malloc_p);
	return;
}

//******************************************************************
// sentenseΡ n byte
//  Ĺn byteʤä顢ʸ
//******************************************************************
void 	cat_after_n_length(unsigned char *sentense,  unsigned int n)
{
	unsigned char	*work_p;

	if (sentense == NULL)
		return;

	// sentense nƱûʤСreturn;
	if ( strlen(sentense) <= n )
	{
		strcpy(sentense, "");
		return;
	}


	//  n byte
	work_p = sentense;
	work_p += strlen(sentense);
	work_p -= n;
	*work_p = '\0';

	return;
}


//******************************************************************
// sentenseʸΡcut_charȴ
//******************************************************************
void 	cut_character(unsigned char *sentense, unsigned char cut_char)
{

	unsigned char 	*symbol_p;
	unsigned char	*malloc_p;
	unsigned char	*work_p;

	if (sentense == NULL)
		return;

	// ƥݥꥨꥢmalloc.
	malloc_p = malloc(strlen(sentense) + 10);	
	if (malloc_p == NULL)
		return;

	symbol_p = sentense;
	work_p = malloc_p;


	// 롼ס
	while (*symbol_p != '\0')
	{
		// оݤΥ饯顢Ф
		if (*symbol_p == cut_char)
		{
			symbol_p++;
		}
		else	// оݥ饯ճä顢ԡ
		{
			*work_p = *symbol_p;
			work_p++;
			symbol_p++;
		}
	}

	// '\0' 򥳥ԡ
	*work_p = *symbol_p;

	// sentense񤭴
	strcpy(sentense, malloc_p);

	free(malloc_p);

	return;
}

//******************************************************************
// sentenseʸΡƬcut_char顢ȴ
//******************************************************************
void 	cut_first_character(unsigned char *sentense, unsigned char cut_char)
{

	unsigned char	*malloc_p;
	unsigned char	*work_p;

	if (sentense == NULL)
		return;

	// ƥݥꥨꥢmalloc.
	malloc_p = malloc(strlen(sentense) + 10);	
	if (malloc_p == NULL)
		return;

	strcpy(malloc_p, sentense);

	work_p = malloc_p;



	// оݥ饯뤫ʤ롣
	while ((*work_p == cut_char) && (*work_p != '\0'))
	{
		work_p++;
	}

	// sentense񤭴
	strcpy(sentense, work_p);

	free(malloc_p);

	return;
}

// ***************************************************************************
// sentenceʸιˡcut_charäȤ
// ***************************************************************************
void 	cut_character_at_linetail(char *sentence, char cut_char)
{
	char	*source_p;
	int		length, i;


	if (sentence == NULL)
		return;

	length = strlen(sentence);	// ʸĹGet

	source_p = sentence;
	source_p += length;		// ݥ󥿤ʸκǸ˥åȡ


	for (i=0; i<length; i++)	// ʸο֤
	{
		source_p--;			// ʸء

		if (*source_p == cut_char)	//  ҥåȤ
		{
			*source_p = '\0';
		}
		else						// 㤦餬ФƤȤǽλ
		{
			break;
		}
	}

	return;
}



/********************************************************************************/
// sentenceʸunique_charϢ³ƤȤunique_char1ʸˤ롣
/********************************************************************************/
void duplex_character_to_unique(unsigned char *sentence, unsigned char unique_char)
{
	unsigned char	*source_p, *work_p;
	unsigned char	work_buf[2048];
	unsigned char	unique_char_count = 0;
	int  counter = 0;

	if (sentence == NULL)
		return;

	source_p = sentence;
	work_p = work_buf;

	// sensenseʸ󤫤顢unique_charʳإԡ
	while ((*source_p != '\0') && (counter < 2048))
	{
		if (*source_p == unique_char)	// unique_charȯ
		{
			if (unique_char_count == 0)	// ǽΰĤʤ饳ԡʳʤ饹åס
			{
				*work_p = *source_p;
				work_p++;
			}
			unique_char_count++;
		}
		else	// unique_char ʳʤ饳ԡ
		{
			unique_char_count = 0;
			*work_p = *source_p;
			work_p++;
		}
		source_p++;
		counter++;
	}

	*work_p = '\0';

	// 顢sentenceء̤᤹
	strncpy(sentence, work_buf, counter+1);

	return;
}




//*********************************************************
// sentenseʸꡢǽ˽Ф褿cut_charʬ䡣
//
//	sentense	(IN) ʬоݤʸͿ롣
//	cut_char	(IN) ʬоݤʸ롣
//	split1		(OUT)åȤ줿ʬ롣sentenseƱΥ˾ޤ
//	split2		(OUT)åȤ줿ʬ롣sentenseƱΥ˾ޤ
//
//
// return 
//		0: 			ｪλ
//		ʳ	顼ʬ伺Ԥʤɤʤɡ
//*********************************************************
int sentense_split(unsigned char *sentense, unsigned char cut_char, unsigned char *split1, unsigned char *split2)
{
	unsigned char 	*p;
	unsigned char	*malloc_p;
	int		sentense_size;

	// 顼å
	if ((sentense == NULL)||(split1 == NULL)||(split2 == NULL))
	{
		return 1;	// NULLޤꡣ
	}

	// sentense ĹGet.
	sentense_size = strlen(sentense);


	// ΰmalloc.
	malloc_p = malloc(sentense_size + 10);

	if (malloc_p == NULL)
	{
		// malloc ԡ顼
		return 1;
	}




	// sentenseʸ˥ԡ
	strcpy(malloc_p, sentense);

	// sentense ˡcut_char ͭ뤫å̵Х顼
	p = strchr(malloc_p, cut_char);
	if (p == NULL)
	{
		free(malloc_p);
		return 1;	// ʬʸȯǤ
	}

	// cut_charꡢ򥫥åȡ
	*p = '\0';

	// Ⱦʬ򥳥ԡ
	strcpy(split1, malloc_p);

	// Ⱦʬ򥳥ԡ
	p++;
	strcpy(split2, p);


	free(malloc_p);

	return 0; // ｪλ
}


// **************************************************************************
// text_buf 顢CR/LF '\0'ޤǤڤФơline_bufcopy
// (CR/LFcopyʤ) 
// ιԤƬΥݥ󥿤return
// Error'\0'줿NULL롣
// **************************************************************************
unsigned char *buffer_distill_line(unsigned char *text_buf_p, unsigned char *line_buf_p, unsigned int line_buf_size )
{
	unsigned char	*p;
	int			counter = 0;

	p = text_buf_p;

	// ------------------
	// CR/LF '\0'õ
	// ------------------
	while ( 1 )
	{
		if ( *p == '\r' ) // CR
		{
			p++;
			continue;
		}

		if ( *p == '\n' )	// LF
		{
			p++;
			break;
		}

		if ( *p == '\0' )
		{
			break;
		}

		p++;
		counter++;
	}

	// --------------------------------------------------
	// ʸline_buf_p ʸ򥳥ԡ
	// --------------------------------------------------
	memset(line_buf_p , '\0', line_buf_size );
	if ( counter >= line_buf_size )
	{
		counter = (line_buf_size -1);
	}
	strncpy(line_buf_p, text_buf_p, counter);

	if ( *p == '\0' )
		return NULL;		// ХåեκǸ
	else
		return p;			// Хåե

}



// **************************************************************************
//  URI󥳡ɤԤޤ.
//  ǽ : URIǥɤԤ
//   : int uri_encode
//  (char* dst,size_t dst_len,const char* src,int src_len);
//   : dst Ѵʸν񤭽Ф.
// 		   dst_len Ѵʸν񤭽ФκĹ.
// 		   src Ѵʸ.
// 		   src_len ѴʸĹ.
//   : 󥳡ɤʸο(Τޤޤޤ)
// **************************************************************************
int uri_encode(unsigned char *dst,  unsigned int dst_len, const unsigned char *src, int src_len)
{
	int idx_src;
	int idx_dst;
	int cnt;


	// å
	if((dst == NULL) || (dst_len < 1) || (src == NULL) || (src_len < 1))
	{
		return 0;
	}

	cnt = 0;
	for (idx_src = idx_dst = 0 ; (idx_src < src_len) && (idx_dst < dst_len) && (src[idx_src] != '\0'); idx_src++)
	{
		if (src[idx_src] == '.' || src[idx_src] == '_' || src[idx_src] == '-')
		{
			dst[idx_dst] = src[idx_src];
			idx_dst += 1;
		}
		else if ( src[idx_src] == ' ' )
		{
			dst[idx_dst] = '+';
			idx_dst += 1;
		}
		else
		{
			if (idx_dst + 3 > dst_len)
				break;

			idx_dst += sprintf(&dst[idx_dst],"%%%2X",(unsigned char)(src[idx_src]));
		}
	  	cnt++;

	  	if (idx_dst + 1 < dst_len)
	  	{
	  		dst[idx_dst] = '\0';
	  	}
	}

	return cnt;
}


// **************************************************************************
// URIǥɤԤޤ.
//  ǽ : URIǥɤԤ
//   : dst Ѵʸν񤭽Ф.
//		  dst_len Ѵʸν񤭽ФκĹ.
//		  src Ѵʸ.
//		  src_len ѴʸĹ.
//  : ǥɤʸο(Τޤޤޤ)
// **************************************************************************
int uri_decode(unsigned char *dst, unsigned int dst_len, const unsigned char *src, unsigned int src_len)
{

	int 		idx_src;
	int 		idx_dst;
	int 		cnt;
	char 		work[3];
	const char	*ptr_stop;
	char		*strtol_end_ptr;
	int 		code;


	// å
	if ((dst == NULL) || (dst_len < 1) || (src == NULL) || (src_len < 1))
	{
		return 0;
	}


  	cnt = 0;
  	ptr_stop = src;

	// =================
	// ᥤ롼
	// =================
	for (idx_src = idx_dst = 0; (idx_src < src_len) && (idx_dst < dst_len) && (src[idx_src] != '\0'); idx_dst++ , cnt++)
	{
		if (src[idx_src] == '%')
		{
			if (idx_src + 2 > src_len)
			{
				break;
			}

			work[0] = src[idx_src+1];
			work[1] = src[idx_src+2];
			work[2] = '\0';

			code = strtol(work, &strtol_end_ptr, 16);
			ptr_stop = &src[idx_src + (strtol_end_ptr - work) + 1];

			if (code == LONG_MIN || code == LONG_MAX)
			{
				break;
			}

			if (strtol_end_ptr != NULL)
			{
				if (*strtol_end_ptr != '\0')
				{
					break;
				}
			}
			dst[idx_dst] = code;
			idx_src += 3;
		}
	  	else if ( src[idx_src] == '+' )
		{
			dst[idx_dst] = ' ';
			idx_src += 1;
			ptr_stop++;
		}
	  	else
		{
			dst[idx_dst] = src[idx_src];
			idx_src += 1;
			ptr_stop++;
		}

	  	if (idx_dst + 1 < dst_len)
	  	{
	  		dst[idx_dst + 1] = '\0';
	  	}
	}

	return cnt;
}

/********************************************************************************/
// "YYYY/MM/DD HH:MM:SS" θߤʸ롣
/********************************************************************************/
void make_datetime_string(unsigned char *sentence)
{
	time_t				now;
	struct tm			*tm_p;

	// ߻Get.
	time(&now);
	tm_p = localtime(&now);

	sprintf(sentence, 	"%04d/%02d/%02d %02d:%02d:%02d", 
						tm_p->tm_year+1900	,	// ǯ
						tm_p->tm_mon+1	,		// 
						tm_p->tm_mday	,		// 
						tm_p->tm_hour	,		// 
						tm_p->tm_min	,		// ʬ
						tm_p->tm_sec		);	// 

	return;
}


/********************************************************************************/
// conv_time 顢"MM/DD HH:MM" ʸ롣
/********************************************************************************/
void conv_time_to_string(unsigned char *sentence, time_t conv_time)
{
	struct tm			*tm_p;

	tm_p = localtime(&conv_time);
	sprintf(sentence, 	"%02d/%02d %02d:%02d", 
						tm_p->tm_mon+1	,		// 
						tm_p->tm_mday	,		// 
						tm_p->tm_hour	,		// 
						tm_p->tm_min		);	// ʬ

	return;
}

/********************************************************************************/
// 100000000  "100.00 MB" ؤѴԤ
//
//	K,M,G б
/********************************************************************************/
void conv_num_to_unit_string(unsigned char *sentence, unsigned int size)
{

	double  d_size;

	if ( size < 1000 )
	{
	  sprintf(sentence, "%d B", size );
	}
	else if ( size < (1000* 1024) )
	{
		d_size = (double)size;
		sprintf(sentence, "%3.2f KB", d_size / 1024.0 );
	}
	else if ( size < (1000 * 1024 * 1024) )
	{
		d_size = (double)size;
		sprintf(sentence, "%3.2f MB", d_size / (1024.0 * 1024.0) );
	}
	else
	{
		d_size = (double)size;
		sprintf(sentence, "%3.2f GB", d_size / (1024.0 * 1024.0 * 1024.0) );
	}

	return;
}








//*******************************************************************
// ǥХåϽ(ե̾å)ؿ
// δؿǽ˸Ƥ֤ޤǤϡǥХåϰڽϤʤ
//*******************************************************************
void debug_log_initialize(const unsigned char *set_debug_log_filename)
{
	// å
	if (set_debug_log_filename == NULL) 
		return;

	if ( strlen(set_debug_log_filename) == 0 )
		return;


	// ǥХåե̾򥻥åȡ
	strncpy(debug_log_filename, set_debug_log_filename,	sizeof(debug_log_filename) );

	// ǥХå λե饰0ˡ
	debug_log_initialize_flag = 0;

	return;
}



//*************************************************
// ǥХåѴؿ
// printf() ƱեޥåȤˤƻѤ롣
//*************************************************
void debug_log_output(char *fmt, ...)
{
	FILE	*fp;
	unsigned char	buf[1024*5+1];
	unsigned char	work_buf[1024*4+1];
	unsigned char	date_and_time[32];
	unsigned char	replase_date_and_time[48];
	va_list 	arg;
	int		len;

	// =========================================
	// ǥХå ե饰å
	// =========================================
	if (debug_log_initialize_flag != 0 )
		return;


	// =========================================
	// Debugʸ
	// Ƭˡdate_and_time Ƥ
	// =========================================
	memset(buf, '\0', sizeof(buf));
	memset(work_buf, '\0', sizeof(work_buf));

	// Ϳ줿ʸŸ
	va_start(arg, fmt);
	vsnprintf(work_buf, sizeof(work_buf), fmt, arg);
	va_end(arg);

	// work_bufΰֺǸ'\n'ĤƤ
	len = strlen(work_buf);
	if (work_buf[len-1] == '\n')
	{
		work_buf[len-1] = '\0';
	}

	// ʸ( "\ndate_and_time" ˤʤ)
	make_datetime_string(date_and_time);
	snprintf(replase_date_and_time, sizeof(replase_date_and_time), "\n%s ", date_and_time );

	// ʸϡ
	snprintf(buf, sizeof(buf), "%s %s", date_and_time, work_buf);
	replase_character(buf, "\n", replase_date_and_time);			// \ndate_and_time

	// ֺǸ'\n'Ĥ롣
	strncat(buf, "\n", sizeof(buf) );	


	// =====================
	// ե
	// =====================
	// ǥХå ơȥå
	output_log_rotate(debug_log_filename);

	// ե륪ץɵ⡼)
	fp = fopen(debug_log_filename, "a");
	if ( fp == NULL )
		return;

	// 
	fwrite(buf, 1, strlen(buf), fp );	// åΤ

	// ե륯
	fclose(fp);

	return;
}


// ************************************************************************
// ե륵¤˰äˡrotate롣
// ************************************************************************
static void output_log_rotate(const char *target_filename)
{
	FILE	*fp;
	int	ret, i;
	struct stat statbuf;
	int	file_size;
	char log_rotate_filename[FILENAME_MAX];	// rotateե̾
	char work_buf[128];

	// rotateоݥե 
	ret = stat(target_filename, &statbuf);
	if ( ret != 0 )	// stat Ԥʤнλ
	{
		return ;
	}

	// fileå
	file_size = statbuf.st_size;

	if ( file_size > OUTPUT_LOG_ROTATE_SIZE )
	{
		// Ψ׻ 1%γΨrotate롣
		if ( (rand() % 100) == 0 )
		{
			for (i=1; i<=OUTPUT_LOG_ROTATE_MAX; i++)
			{
				// rotateե̾롣
				memset(log_rotate_filename, '\0', sizeof(log_rotate_filename));
				strncpy(log_rotate_filename, target_filename, sizeof(log_rotate_filename)-1);

				snprintf(work_buf, sizeof(work_buf), ".%d", i);
				strncat(log_rotate_filename, work_buf, sizeof(log_rotate_filename)-1);

				//ե뤬¸ߤʤå¸ߤƤcontinue
				fp = fopen(log_rotate_filename, "r");
				if (fp == NULL )
				{
					// ե̾ޤä顢rotate¹
					rename(target_filename, log_rotate_filename);
					break;
				}
				fclose ( fp );
			}
		}
	}

	return;
}


// **************************************************************************
// ĥѹɲѡ	
//	extension_convert_list˽org  rename ؤѴԤ
// 
// ) "hogehoge.m2p"  "hogehoge.m2p.mpg"
// **************************************************************************
void extension_add_rename(unsigned char *rename_filename_p)
{
	int i;
	unsigned char	work[FILENAME_MAX];

	for ( i=0; ; i++ )
	{
		if ( extension_convert_list[i].org_extension == NULL )
			break;

		debug_log_output("org='%s', rename='%s'", 	extension_convert_list[i].org_extension, 
													extension_convert_list[i].rename_extension);

		strncpy(work, rename_filename_p, sizeof(work));

		// ӤĥҤƱĹˤ롣
		cat_before_n_length(work, strlen(extension_convert_list[i].org_extension));

		// ĥҰס
		if ( strcasecmp(work, extension_convert_list[i].org_extension) == 0 )
		{
			debug_log_output(" HIT!!!" );
			// Υե뤫顢ĥʬ
			strncpy(work, rename_filename_p, sizeof(work));
			cat_after_n_length(work, strlen(extension_convert_list[i].org_extension));
			// rename줿ĥҤɲá
			strncat(work, extension_convert_list[i].rename_extension, sizeof(work));
			strcpy(rename_filename_p, work);

			debug_log_output("rename_filename_p='%s'", rename_filename_p);
			break;
		}
	}


	return;
}


// **************************************************************************
// ĥѹѡ
//	extension_convert_list˽rename  org ؤѴԤ
// 
// ) "hogehoge.m2p.mpg"  "hogehoge.m2p"
// **************************************************************************
void extension_del_rename(unsigned char *rename_filename_p)
{
	int i;
	unsigned char	work[FILENAME_MAX];

	for ( i=0; ; i++ )
	{
		if ( extension_convert_list[i].org_extension == NULL )
			break;

		debug_log_output("org='%s', rename='%s'", 	extension_convert_list[i].org_extension, 
													extension_convert_list[i].rename_extension);

		strncpy(work, rename_filename_p, sizeof(work));

		// ӤĥҤƱĹˤ롣
		cat_before_n_length(work, strlen(extension_convert_list[i].rename_extension));

		// ĥҰס
		if ( strcasecmp(work, extension_convert_list[i].rename_extension) == 0 )
		{
			debug_log_output(" HIT!!!" );

			// Υե뤫顢ĥʬ
			strncpy(work, rename_filename_p, sizeof(work));
			cat_after_n_length(work, strlen(extension_convert_list[i].rename_extension));

			// rename줿ĥҤɲá
			strncat(work, extension_convert_list[i].org_extension, sizeof(work));
			strcpy(rename_filename_p, work);

			debug_log_output("rename_filename_p='%s'", rename_filename_p);
			
			break;
		}
	}

	return;
}



