#---------------------------------------------------
# Limo WEB-BBS System.
#   Article class - ƥ륯饹
#
#                      1st Maintaner   Rero2@fumi.
#
#---------------------------------------------------

#------------------------------------
# 
# $Id: bbs_article.rb,v 1.2 2002/02/02 03:10:52 rero2 Exp $
#
# Feb.01.2002 - rero2@fumi
#   htmlɽʬϥޥ褦˥饹󥯥å
#   б
# Jan.06.2002 - rero2@fumi
#   ϡʳ̤꽪ä
#
#----

#
# ߤΥƥ빽
#                 (Jan.06.2002)
#
#  a_serial    - ʥС (ɬ)
#  a_crypt     - Խѥѥɥϥå
#  a_topic     - ȥԥå(åɥȥ) (ɬ)
#  a_parent    - Ƶ (ɬ)
#  a_title     - Υȥ (ɬ)
#  a_date      - 񤭹 (ɬ)
#  a_edit      - 
#  a_auther    - Ҽ (ɬ)
#  a_email     - Ҽԥ᡼륢ɥ쥹
#  a_homepage  - Ҽԥۡڡ
#  a_reference - ȡ
#  a_icon      - ƥ륢(reserved)
#  a_talk      -  (ɬ)
#
#  ¾ɬפǤä饯饹ŬɲäƤ
#


#---------------------------------------------------
# 饤֥䳰ե
#---------------------------------------------------

require 'jcode'
require "bbs_database.rb"
require "config.rb"

#---------------------------------------------------
# 
#---------------------------------------------------



#-----------------------------------------------------
# 饹
#-----------------------------------------------------

#---------------------------------------------
#----- ƥǡݻ饹
#
class  Article
  #-------------------------------------
  #--- ѥ᡼
  #  db = ǡ١֥
  def initialize(db)
    @bbs_db = db
    # -- ƥǡν()
    @a_serial = 0
    @a_crypt = ''
    @a_topic = ''
    @a_parent = ''
    @a_title = ''
    @a_date = 0
    @a_edit = ''
    @a_auther = ''
    @a_email = ''
    @a_homepage = ''
    @a_reference = ''
    @a_icon = ''
    @a_talk = ''
  end


  #-------------------------------------
  #--- HTMLؤѴǥǡϤ
  #  === Ӥ˹碌ƥС饤ɤƤ ===
  #    Υ᥽åɤȤ鷺˥᥽åɤƥǡФ
  #    ǥ󥰤ΤȻפޤ
  def html_article
    output = ''
    # -- ơ֥
    output << '<table cellpadding="2" cellspacing="1" border="0" width="90%">'
    output << "\n"
    # -- ƥ륿ȥ
    serial = sprintf("No.%06d\n", @a_serial)
    link_serial = sprintf("<A HREF=\"%s?id=%d\" CLASS=\"hide\">", Baseurl, @a_serial)
    link_serial << serial
    link_serial << "</A>\n"
    output << "  <tr>\n"
    output << '    <td bgcolor="#e0ffff" width="24%">' + "\n"
    output << '      <font color="#000000"><b>' + "\n"
    output << link_serial
    output << "      </b></font>\n"     
    output << "    </td>\n"
    output << '    <td bgcolor="#6666b0">' + "\n"
    output << '      <font color="#ffffff" size="+1"><b>' + "\n"
    output << sprintf("        %s\n", @a_title)
    output << "      </b></font>\n"     
    output << "    </td>\n"
    output << "  </tr>\n"
    # -- 񤭹
    t = Time::at(@a_date)
    date = sprintf("%s", t.strftime("%b.%d.%Y %H:%M'%S"))
    output << "  <tr>\n"
    output << '    <td bgcolor="#ccccff">' + "\n"
    output << '      <font color="#505050">' + "\n"
    output << "        Date :\n"
    output << "      </font>\n"     
    output << "    </td>\n"
    output << '    <td bgcolor="#ffffff">' + "\n"
    output << '      <font color="#000000">' + "\n"
    output << sprintf("        %s\n", date)
    output << "      </font>\n"     
    output << "    </td>\n"
    output << "  </tr>\n"
    # -- Ҽ
    output << "  <tr>\n"
    output << '    <td bgcolor="#ccccff">' + "\n"
    output << '      <font color="#505050">' + "\n"
    output << "        Auther :\n"
    output << "      </font>\n"     
    output << "    </td>\n"
    output << '    <td bgcolor="#ffffff">' + "\n"
    output << '      <font color="#000000">' + "\n"
    if @a_email == '' then
      output << sprintf("        %s\n", @a_auther)
    else
      output << sprintf("        <a href=\"mailto:%s\">\n", @a_email)
      output << sprintf("          %s\n", @a_auther)
      output << "        </a>\n"
    end
    unless @a_homepage == '' then
      output << sprintf("        <a href=\"%s\">\n", @a_homepage)
      output << " [Homepage]\n"
      output << "        </a>\n"
    end
    output << "      </font>\n"     
    output << "    </td>\n"
    output << "  </tr>\n"
    # -- Υȥԥå
    output << "  <tr>\n"
    output << '    <td bgcolor="#ccccff">' + "\n"
    output << '      <font color="#505050">' + "\n"
    output << "        Topic :\n"
    output << "      </font>\n"     
    output << "    </td>\n"
    output << '    <td bgcolor="#ffffff">' + "\n"
    output << '      <font color="#000000">' + "\n"
    output << sprintf("        %s\n", @a_topic)
    output << "      </font>\n"     
    output << "    </td>\n"
    output << "  </tr>\n"
    # -- ƵؤΥ
    unless @a_parent == '' then
      tmp = @a_parent
      tmp.gsub!(/\n/, "<br>\n")
      tmp.gsub!(/@/, Baseurl+'?id=')
      output << "  <tr>\n"
      output << '    <td bgcolor="#ccccff">' + "\n"
      output << '      <font color="#505050">' + "\n"
      output << "        Parent Article :\n"
      output << "      </font>\n"     
      output << "    </td>\n"
      output << '    <td bgcolor="#ffffff">' + "\n"
      output << '      <font color="#000000">' + "\n"
      output << sprintf("        %s\n", autolink(tmp))
      output << "      </font>\n"     
      output << "    </td>\n"
      output << "  </tr>\n"
    end
    # -- ȡ
    unless @a_reference == '' then
      tmp = @a_reference
      tmp.gsub(/\n/, "<br>\n")
      output << "  <tr>\n"
      output << '    <td bgcolor="#ccccff">' + "\n"
      output << '      <font color="#505050">' + "\n"
      output << "        Reference :\n"
      output << "      </font>\n"     
      output << "    </td>\n"
      output << '    <td bgcolor="#ffffff">' + "\n"
      output << '      <font color="#000000">' + "\n"
      output << sprintf("        %s\n", autolink(tmp))
      output << "      </font>\n"     
      output << "    </td>\n"
      output << "  </tr>\n"
    end
    # -- ѹ
    unless @a_edit == '' then
      tmp = @a_edit
      tmp.gsub!(/&#10;/, "<br>\n")
      output << "  <tr>\n"
      output << '    <td bgcolor="#ccccff">' + "\n"
      output << '      <font color="#505050">' + "\n"
      output << "        Edit history :\n"
      output << "      </font>\n"     
      output << "    </td>\n"
      output << '    <td bgcolor="#ffffff">' + "\n"
      output << '      <font color="#000000">' + "\n"
      output << sprintf("        %s\n", tmp)
      output << "      </font>\n"     
      output << "    </td>\n"
      output << "  </tr>\n"
    end
    # -- ƥ
    tmp = @a_talk
    tmp.gsub!(/&#10;/, "<br>")
    tmp.gsub!(/&#32;/, ' ')
    output << "  <tr>\n"
    output << '    <td bgcolor="#ffffff">' + "\n"
    unless @a_icon == '' then
      # - ե(reserve)
      output << "      <center>\n"
      output << sprintf("        <img src=\"%s\">\n", @a_icon)
      output << "      </center>\n"
    end
    output << "    </td>\n"
    output << '    <td bgcolor="#e0ffff">' + "\n"
    output << '      <font color="#404040">' + "\n"
    output << sprintf("        %s\n", autolink(tmp))
    output << "      </font>\n"     
    output << "    </td>\n"
    output << "  </tr>\n"
    # -- ޤ
    output << "</table>\n"
    output
  end



  #-------------------------------------
  #--- ǡ١ɤ߹
  def get_article(num)
    article = @bbs_db.get(num)
    # -- ǡβϡŸ
    tag2dat(article)
  end


  #-------------------------------------
  #--- ǡ١ؿ񤭹
  def write_article
    @a_serial = @bbs_db.length + 1
    stamp = Time::now
    @a_date = stamp.to_i
    out = dat2tag
    @bbs_db.append(out)
  end


  #-------------------------------------
  #--- ǡ١ؽ񤭹
  def edit_article
    stamp = Time::now
    @a_edit << sprintf("\n%s&#10;", stamp.strftime("%b.%d.%Y %H:%M'%S"))
    out = dat2tag
    @bbs_db.edit(@a_serial.to_i - 1, out)
  end


  #-------------------------------------
  #--- ᥽åɷ
  def set_serial(num)
    @a_serial = num
  end
  def get_serial
    @a_serial
  end
  # -
  def set_crypt(st)
    @a_crypt = st
  end
  def get_crypt
    @a_crypt
  end
  # -
  def set_topic(st)
    @a_topic = st
  end
  def get_topic
    @a_topic
  end
  # -
  def set_parent(st)
    @a_parent = st
  end
  def get_parent
    @a_parent
  end
  # -
  def set_title(st)
    @a_title = st
  end
  def get_title
    @a_title
  end
  # -
  def set_date(num)
    @a_date = num
  end
  def get_date
    @a_date
  end
  # -
  def set_edit(st)
    @a_edit = st
  end
  def get_edit
    @a_edit
  end
  # -
  def set_auther(st)
    @a_auther = st
  end
  def get_auther
    @a_auther
  end
  # -
  def set_email(st)
    @a_email = st
  end
  def get_email
    @a_email
  end
  # -
  def set_homepage(st)
    @a_homepage = st
  end
  def get_homepage
    @a_homepage
  end
  # -
  def set_reference(st)
    @a_reference = st
  end
  def get_reference
    @a_reference
  end
  # -
  def set_icon(st)
    @a_icon = st
  end
  def get_icon
    @a_icon
  end
  # -
  def set_talk(st)
    @a_talk = st
  end
  def get_talk
    @a_talk
  end
  # -




  #- - - - - ʲץ饤١ȥꥢ
  private

  #-------------------------------------
  #--- http: ǻϤޤ URL ʸ˥󥯤Ź
  def autolink(str)
    body = String::new(str)
    body.gsub!(/(http:\/\/[\/a-zA-Z0-9\.~?=&\-]+)/) {
      "<A HREF=\""+$1+"\">"+$1+"</A>"
    }
    body.gsub!(/(ftp:\/\/[\/a-zA-Z0-9\.~?=&\-]+)/) {
      "<A HREF=\""+$1+"\">"+$1+"</A>"
    }
    body
  end

  #-------------------------------------
  #--- ǡ١ϿΥեѴ
  #  == XMLȤϤŬڤ˽񤭴 ==
  def dat2tag
    output = ''
    # -- ǽ
    exit if @a_serial == 0
    output << sprintf("<serial> %d </serial>\n", @a_serial)
    exit if @a_topic == ''
    output << sprintf("<topic> %s </topic>\n", @a_topic)
    unless @a_parent == '' then
      output << sprintf("<parent> %s </parent>\n", @a_parent)
    end
    unless @a_crypt == '' then
      output << sprintf("<crypt> %s </crypt>\n", @a_crypt)
    end
    unless @a_title == '' then
      output << sprintf("<title> %s </title>\n", @a_title)
    end
    unless @a_date == 0 then
      output << sprintf("<date> %d </date>\n", @a_date)
    end
    unless @a_edit == '' then
      output << sprintf("<edit> %s </edit>\n", @a_edit)
    end
    unless @a_auther == '' then
      output << sprintf("<auther> %s </auther>\n", @a_auther)
    end
    unless @a_email == '' then
      output << sprintf("<email> %s </email>\n", @a_email)
    end
    unless @a_homepage == '' then
      output << sprintf("<homepage> %s </homepage>\n", @a_homepage)
    end
    unless @a_reference == '' then
      output << sprintf("<reference> %s </reference>\n", @a_reference)
    end
    unless @a_icon == '' then
      output << sprintf("<icon> %s </icon>\n", @a_icon)
    end
    unless @a_talk == '' then
      output << sprintf("<talk>\n%s\n</talk>\n", @a_talk)
    end
    # -- ޤ(ᤷ)
    output
  end



  #-------------------------------------
  #--- ǡ١ΥեŸ
  #  == XMLȤϤѹ(Ϥ) ==
  def tag2dat(article)
    parse = TagLex::new(article)
    while parse.index > 0 do
      bit = parse.next
      if bit =~ /<([a-zA-Z0-9/_\- ]+)>/ then
        tag = $1
        item = parse.area(bit) 
        item.gsub!(/^ /, '')
        item.gsub!(/ $/, '')
        case tag
          when 'serial'
            @a_serial = item.to_i
          when 'crypt'
            item.gsub!(/\n/, '')
            @a_crypt = item
          when 'topic'
            item.gsub!(/\n/, '')
            @a_topic = item
          when 'parent'
            item.gsub!(/\n/, '')
            item.gsub!(/&#10;/, "\n")
            @a_parent = item
          when 'title'
            item.gsub!(/\n/, '')
            @a_title = item
          when 'date'
            @a_date = item.to_i
          when 'edit'
            item.gsub!(/\n/, '')
            @a_edit = item
          when 'auther'
            item.gsub!(/\n/, '')
            @a_auther = item
          when 'email'
            item.gsub!(/\n/, '')
            @a_email = item
          when 'homepage'
            item.gsub!(/\n/, '')
            @a_homepage = item
          when 'reference'
            item.gsub!(/\n/, '')
            item.gsub!(/&#10;/, "\n")
            @a_reference = item
          when 'icon'
            item.gsub!(/\n/, '')
            @a_icon = item
          when 'talk'
            @a_talk = item
        end
      end
    end
  end

end




#---------------------------------------------
#----- ǡϥ饹
#  == ʤФXML٤Ȼפ ==
#     ϥ⥸塼餺ǽ񤤤Ƥ(Τ˴ʰ)
class  TagLex
  #-------------------------------------
  #--- ѥ᡼
  #  article = ƥե
  def initialize(article)
    @lex = Array::new
    doc = String::new(article)
    # -- ȤǤʤ¤ڤʬ
    while doc.length > 0 do
      nexttag = doc.index(/(<[a-zA-Z0-9/_\- ]+>)/)
      if nexttag == nil then
        @lex.push(doc)
        break
      elsif nexttag == 0 then
        @lex.push($1)
	doc = doc[$1.length..(doc.length - 1)]
      else
        @lex.push(doc[0, nexttag])
	doc = doc[nexttag..(doc.length - 1)]
      end
    end
  end


  #-------------------------------------
  #--- ĤǿϤ
  def index
    @lex.size
  end


  #-------------------------------------
  #--- 1ǤϤ
  def next
    @lex.shift
  end


  #-------------------------------------
  #--- ǰϤޤ줿ϰϤϤ
  def area(tag)
    output = ''
    tag =~ /<(.+)>/
    close_tag = "</"+$1+">"
    while @lex.size > 0 do
      bit = @lex.shift
      break if bit == close_tag
      output << bit
    end
    output
  end

end




#---------------------------------------------
#----- ѥƥ륯饹
#        ǥ󥯥å֤ html_article 򥫥ޥ
#        Ǥ褦ˤƤ
#
class  ArticleClass < Article

  #--------------------------------------------------------
  #--- html_article 򥪡С饤ɤƥꥸʥɽ

end