#---------------------------------------------------
# Limo WEB-BBS System.
#   Wiki view - WikiWiki mode class
#
#                      1st Maintaner   Rero2@fumi.
#
#---------------------------------------------------

#------------------------------------
# 
# $Id: author_list.rb,v 1.2 2002/05/15 14:51:43 rero2 Exp $
#
# May.06.2002 - rero2
#   
#
#----

#---------------------------------------------------
# 饤֥䳰ե
#---------------------------------------------------

require 'jcode'
require "bbs_database.rb"
require "bbs_article.rb"
require "bbs_hierarchy.rb"
require "config.rb"

# ------------------------------------------------------ #
#  Hierarchy Class                                       #
# ------------------------------------------------------ #

# ---- 񤭹ҤȤΥꥹȤ뤿Hierarchy

class AuthorHierarchy < Hierarchy
  # 񤭹ҤȤ
  attr :authors

  # db ǡ١
  # num 
  def initialize(db, num)
    # --- ƥ饹θƤӽФ
    super(db)
    # --- Ϣɤ߽Ф᥽å
    listup(num)
    # --- ȯԤ
    @authors = Array::new
    @relation.each do |article|
      if !(@authors.include?(article.author)) then
	@authors << article.author
      end
    end
    @authors
  end

  #- - - - - ʲץ饤١ȥꥢ
  private

  #-------------------------------------
  #--- ǡ򿷤Ф
  def listup(num)
    max = @bbs_db.length
    if num < max then
      index = num
    else
      index = max
    end
    for i in 0...index
      art = RutoArticle::new(@bbs_db)
      art.get_article(max-1-i)
      @relation << art
      @length += 1
    end
  end

end



# ------------------------------------------------------ #
#  Article Class                                         #
# ------------------------------------------------------ #

# --- Ȥڤʬ html ƥ

class RutoArticle < Article
  # 
  def initialize(db)
    super(db)
  end

  # ΥƥHTMLɽ֤
  # Ȥפ褦ʬƤߤ롣
  def html_article
    html_article_body
  end

  # 
  def html_article_body
    html_article_title <<
    html_article_date <<
    html_article_author <<
    html_article_topic <<
    html_article_parent <<
    html_article_reference <<
    html_article_edit <<
    html_article_icon <<
    html_article_talk
  end

  # ȥ
  def html_article_title
    %(<h2>#{@a_title}</h2>\n)
  end

  # 
  def html_article_date
    t = Time::at(@a_date)
    %(<span>#{t.strftime("%b.%d.%Y %H:%M'%S")}</span><br>\n)
  end

  # ԤȤؤΥ
  def html_article_author
    mail_elem = ''
    if @a_email != ''
      mail_elem = %( <a href="mailto:#{email}">#{email}</a>)
    end
    hoempage_elem = ''
    if @a_homepage != ''
      homepage_elem = %( <a href="#{homepage}">[Home]</a>)
    end
    %(<span>#{@a_author}#{mail_elem}#{homepage_elem}</span><br>\n)
  end

  # ȥԥå
  def html_article_topic
    %(ȥԥå: <span>#{@a_topic}</span><br>\n)
  end

  # ƵؤΥ
  def html_article_parent
    return '' if @a_parent == ''
    tmp = @a_parent
    tmp.gsub!(/\n/, "<br>\n")
    tmp.gsub!(/@/, Baseurl+'?id=')
    %(Ƶ: <span>#{autolink(tmp)}</span><br>\n)
  end

  # 
  def html_article_reference
    return '' if @a_reference == ''
    tmp = @a_reference
    tmp.gsub(/\n/, "<br>\n")
    %(: <span>#{autolink(tmp)}</span><br>\n)
  end

  # ѹ
  def html_article_edit
    return '' if @a_edit == ''
    tmp = @a_edit    
    tmp.gsub!(/&#10;/, "<br>\n")
    %(ѹ: <span>#{tmp}</span><br>\n)
  end

  # 饢
  def html_article_icon
    return '' if @a_icon == ''
    %(<img alt="" src="#{icon}"><br>\n)
  end

  # ʸ
  def html_article_talk
    tmp = @a_talk
    tmp.gsub!(/&#10;/, "<br>")
    tmp.gsub!(/&#32;/, ' ')
    %(<div>#{autolink(tmp)}</div><br>\n)
  end

end
