#!/usr/local/bin/ruby
#
# $Id: author_list_bbs.cgi,v 1.1 2002/02/19 17:21:33 rero2 Exp $
#

basedir= './'
$:.push basedir

require 'cgi'
require "config.rb"
require "bbs_database.rb"
require "bbs_article.rb"
require "bbs_hierarchy.rb"
require "metaphor.rb"
require "author_list.rb"

Bbs_cgi_url = "author_list_bbs.cgi"


# -----------------------------------------------
# --- ǡ١

input = CGI.new
max_tmp = input.params['max'][0] or '10'
name = input.params['name'][0]

max = Maxarticle
unless max_tmp == nil then
  if max_tmp.to_i < max then 
    max = max_tmp.to_i
  end
end

db = Ezdb::new(basedir+Datadir, Dataname)
list = AuthorHierarchy::new(db, max)
if (name == nil) and (list != nil) then
  if list.length > 0 then
    name = list.get_article(0).get_author
  end
end


# -----------------------------------------------
# --- إå

print <<'END_OF_HEADER'
Content-type: text/html; charset=euc-jp
Content-Language: ja

<html lang="ja">
<head>
<link rel="stylesheet" href="metaphor.css" media="all" type="text/css">

<title>LiMo BBS Who's Who</title>
</head>
<body>

<h1>LiMo BBS - Author View</h1>

<HR noshade>
END_OF_HEADER


# -----------------------------------------------
# --- ɽ

print '<p> [ '

[5,10,15,25,50,100,200,500].each do |i|
  if i != max
    printf("<a href=\"%s?max=%d;name=%s\">%d</a>/", Bbs_cgi_url, i, name, i)
  else
    print i, ' '
  end
end

print "]</p>\n"

print '<p>ɽ [ '

list.authors.each do |author|
  if author != name
    printf("<a href=\"%s?max=%d;name=%s\">%s</a>/", Bbs_cgi_url, max, author, author)
  else
    print author, '/'
  end
end

print "]</p>\n"


# -----------------------------------------------
# --- Ƕȯ

print "<!----- ƥɽ ----->\n"

print "<p>#{name}ȯ</p>\n"

class RutoArticle
  def html_article_body
    html_article_title <<
    html_article_date <<
    #̾ɽʤ
    #html_article_author <<
    html_article_topic <<
    html_article_parent <<
    html_article_reference <<
    html_article_edit <<
    html_article_icon <<
    html_article_talk
  end
end

num = list.length
for i in 0...num
  art = list.get_article(i)
  if art.author == name
    print art.html_article
  end
end


# -----------------------------------------------
# --- եåɽ

print <<'END_OF_FOOTER'

<!-- եå -->
<hr noshade>
<p>LiMo BBS System - Author View
<br>
$Id: author_list_bbs.cgi,v 1.1 2002/02/19 17:21:33 rero2 Exp $
</p>

</body>
</html>
END_OF_FOOTER
