#---------------------------------------------------
# Limo WEB-BBS System.
#   Database class - ǡ١饹
#
#                      1st Maintaner   Rero2@fumi.
#
#---------------------------------------------------

#------------------------------------
# 
# $Id: bbs_database.rb,v 1.4 2002/03/22 16:34:46 rero2 Exp $
#
# Mar.21.2002 - rero2@fumi
#   Wiki Note ĥTopic List εϿʤ
#
# Jan.05.2002 - rero2@fumi
#   ϡޤʤ˴λ
#
#----

#---------------------------------------------------
# 饤֥䳰ե
#---------------------------------------------------

#---------------------------------------------------
# 
#---------------------------------------------------

# --- ƥĤǥեʬ뤫
Maxpack = 500



#-----------------------------------------------------
# 饹
#-----------------------------------------------------

class  Ezdb
  #-------------------------------------
  #--- ѥ᡼
  #  dir = ǡݴɥǥ쥯ȥ
  #  suffix = ե̾դ̾
  def initialize(dir, suffix)
    @bbs_dir = dir
    @bbs_name = suffix
    @lockfile = @bbs_dir + "/db_lock"
    @lockfile.gsub!(/\/\//, '/')
    @topicfile = @bbs_dir + "/topiclist.dat"
    @topicfile.gsub!(/\/\//, '/')
    @wikifile = @bbs_dir + "/wikiname.dat"
    @wikifile.gsub!(/\/\//, '/')
  end


  #-------------------------------------
  #--- ߤΥǡ¬
  def length
    maxidx = 0
    num = 0
    idx = ''
    filelist = Dir::open(@bbs_dir)
    filelist.each do |file|
      # -- ǥåեΤοͤʪ
      if file =~ /([0-9])+\.idx/i then
        maxidx = $1.to_i
        idx = file
      end
    end
    idx = @bbs_dir.untaint + "/" + idx.untaint
    idx.gsub!(/\/\//, '/')
    idx.gsub!(/\.\//, '')
    # -- ǥåեΥƥ夲
    if maxidx > 0 then
      readidx = open(idx, "r")
      readidx.each_line do |id|
        num += 1 if id =~ /[0-9]+/
      end
      num += (maxidx - 1) * Maxpack
    end
    # -- 
    num
  end

  alias size length


  #-------------------------------------
  #--- ǡɲ
  def append(data)
    lock
    # -- ¸ƥ
    artnum = length
    # -- ǡե̾
    name = @bbs_dir + sprintf("/%s%08d", @bbs_name, ((artnum / Maxpack) + 1))
    name.gsub!(/\/\//, '/')
    # -- ǡɲ
    fp = open(name+".dat", "a")
    fp.seek(0, IO::SEEK_END)
    newpos = fp.pos
    fp.print("<article>\n")
    fp << data      
    fp.print("\n</article>\n")
    fp.close
    # -- ݥ󥤥ǥåɲ
    fid = open(name+".idx", "a")
    fid.seek(0, IO::SEEK_END)
    fid.printf("%d\n", newpos)
    fid.close
    unlock
  end

  alias add append
  alias new append


  #-------------------------------------
  #--- ¸ǡκ
  def edit(num, data)
    lock
    # -- ¸ƥ
    artnum = length
    exit if (num < 0) || (num >= artnum)
    # -- ǡե̾
    name = @bbs_dir + sprintf("/%s%08d", @bbs_name, ((num / Maxpack) + 1))
    name.gsub!(/\/\//, '/')
    # -- ǥå
    sp = 0
    count = num % Maxpack
    index = open(name+".idx")
    index.each_line do |sp|
      if sp =~ /[0-9]+/ then
        break if count == 0
        count -= 1
      end
    end
    if ((artnum % Maxpack) == (Maxpack - 1)) || ((num + 1) == artnum) then
      ep = 0
    else
      index.each_line do |ep|
        break if ep =~ /[0-9]+/
      end
    end
    index.close
    # -- ƥݥե˽񤭽Ф
    dat = open(name+".dat")
    tmp = open(name+".tmp", "w")
    if sp.to_i > 0 then
      block = dat.read(sp.to_i)
      tmp << block
    end
    tmp.print("<article>\n")
    tmp << data
    tmp.print("\n</article>\n")
    if ep.to_i > 0 then
      dat.pos = ep.to_i
      block = dat.read
      tmp << block
    end
    dat.close
    tmp.close
    # -- ƥݥե뤫饳ԡ
    dat = open(name+".dat", "w")
    tmp = open(name+".tmp", "r")
    block = tmp.read
    dat << block
    dat.close
    tmp.close
    File::delete(name+".tmp")
    # -- ǥåκľ
    dat = open(name+".dat")
    index = open(name+".idx", "w")
    dat.each_line do |line|
      if line =~ /<article>/i then
        pos = dat.pos - line.length + line.index(/<article>/i)
        index.printf("%d\n", pos)
      end
    end
    dat.close
    index.close
    # -- λ
    unlock
  end


  #-------------------------------------
  #--- ¸ǡμ
  def get(num)
    body = ''
    if (length >= 0) and (num < length)  then
      # -- ե̾
      name = @bbs_dir + sprintf("/%s%08d", @bbs_name, ((num / Maxpack) + 1))
      name.gsub!(/\/\//, '/')
      # -- ǥå
      pos = -1
      count = num % Maxpack
      index = open(name+".idx")
      index.each_line do |pos|
        if pos =~ /[0-9]+/ then
          break if count == 0
          count -= 1
        end
      end
      index.close
      # -- ǡ
      input = open(name+".dat")
      input.pos = pos.to_i
      input.each_line do |line|
        if line =~ /<\/article>/i then
          # - λȽ
          ep = line.index(/<\/article>/i)
          body << line[0..ep] if ep > 0
          break
        elsif line =~ /<article>/i then
          # - ϥϽ
          ep = line.length
          sp = line.index(/<article>/i) + 10
          body << line[sp..ep]
        else
          # - ̾ɲ
          body << line
        end
      end
    end
    # -- 
    body
  end

  alias article get


  #-------------------------------------
  #--- ǡ١Υåå
  def lock_check
    ret = 0
    if File::exist?(@lockfile)
      # --- åƤƤ֤ФƤ̵
      lasttime = Time::now - File::mtime(@lockfile)
      if lasttime < (60 * 3)
        ret = 1
      end
    end
    ret
  end



  #--------------------------------------------------------
  #
  # -- Wiki Note ĥ
  #
  #--------------------------------------------------------

  #-------------------------------------
  #--- 񤭹ߤäȥԥåεϿ
  def topic_list_write(topic, serial, wikiflag)
    lock
    tlist = Hash::new(0)
    tarray = Array::new
    wikipage = 0;
    if File::exist?(@topicfile) then
      fp = open(@topicfile, "r")
      for flist in fp
        flist =~ /([0-9]+)\s([0-9]+)\s([0-9]+)\s(.*)/
        tlist[$4] = $1.to_i
        wikipage = $3.to_i  if $4 == topic
        tarray.push(flist)
      end
      fp.close
    end
    if wikiflag == true then
      wikipage = serial
    end
    fp = open(@topicfile, "w")
    fp << sprintf("%d %d %d %s\n", tlist[topic]+1, serial, wikipage, topic)
    tarray.each do |topic_line|
      topic_line =~ /([0-9]+)\s([0-9]+)\s([0-9]+)\s(.*)/
      fp << topic_line unless $4 == topic
    end
    fp.close
    unlock
  end


  #-------------------------------------
  #--- ȥԥåꥹȤμ
  def topic_list_read
    topiclist = Array::new
    if File::exist?(@topicfile) then
      fp = open(@topicfile, "r")
      for flist in fp
        topiclist << flist
      end
      fp.close
    end
    # -- (array)
    topiclist
  end





  #- - - - - ʲץ饤١ȥꥢ
  private

  #-------------------------------------
  #--- ǡ١Υåå
  def lock
    unlock if File::exist?(@lockfile)
    fp = open(@lockfile, "w")
    fp.print(Time::now)
    fp.close
  end

  def unlock
    File::delete(@lockfile)
  end


end


