#---------------------------------------------------
# Limo WEB-BBS System.
#   Metaphor BBS view - ᥿եBBS
#       Ȥ BBS View
#
#                      1st Maintaner   Ruto.
#                      2nd Maintaner   Rero2@fumi.
#
#---------------------------------------------------

#------------------------------------
# 
# $Id: metaphor.rb,v 1.1 2002/02/07 15:20:35 rero2 Exp $
#
# Feb.07.2002 - ruto, rero2@fumi
#   Ȥ󤫤󶡤줿ɤư褦˼ľ
#
#----

#---------------------------------------------------
# 饤֥䳰ե
#---------------------------------------------------

require 'jcode'
require "bbs_database.rb"
require "bbs_article.rb"
require "config.rb"


#---------------------------------------------------
# 
#---------------------------------------------------

Filterfile = 'metaphorfilter.dat'

# ------------------------------------------------------ #
#  Hierarchy Class                                       #
# ------------------------------------------------------ #

#---------------------------------------------
#----- ǿ񤭹ߥꥹ
#
class  MetaphorNewArticle < Hierarchy
  #-------------------------------------
  #--- ѥ᡼
  #  db = ǡ١֥
  #  num = ǿĤФ
  def initialize(db, num)
    # --- ƥ饹θƤӽФ
    super(db)
    # --- Ϣɤ߽Ф᥽å
    listup(num)
  end

  #- - - - - ʲץ饤١ȥꥢ
  private

  #-------------------------------------
  #--- ǡ򿷤Ф
  def listup(num)
    max = @bbs_db.length
    if num < max then
      index = num
    else
      index = max
    end
    for i in 0...index
      art = MetaphorArticle::new(@bbs_db)
      art.get_article(max-1-i)
      @relation << art
      @length += 1
    end
  end
  
end


#---------------------------------------------
#----- ƥĤȴФ
#
class  MetaphorOnlyArticle < Hierarchy
  #-------------------------------------
  #--- ѥ᡼
  #  db = ǡ١֥
  #  num = ǿĤФ
  def initialize(db, num)
    # --- ƥ饹θƤӽФ
    super(db)
    # --- ǡĤ֤
    art = MetaphorArticle::new(@bbs_db)
    art.get_article(num-1)
    @relation << art
    @length += 1
  end
  
end





# ------------------------------------------------------ #
#  Article Class                                         #
# ------------------------------------------------------ #

# ᥿եȤ˥Ѥ뵭
class MetaphorArticle < Article
  # 
  def initialize(db)
    super(db)
    init_filter
  end

  # °᥿ե̾
  def metaphor
    # ----- ΤȤΥɤ rindex ȤäƤ
    #       ruby1.4 ̵ǤʤΤǽ񤭴
    #                              Feb.07.2002 rerofumi
    @a_icon =~ /.*\/([^\/]+)\.[^\.]*$/
    $1
  end

  alias get_metaphor metaphor

  # ΥƥHTMLɽ֤
  # Ȥפ褦ʬƤߤ롣
  def html_article
    html_article_header << html_article_body << html_article_footer
  end

  # view¦Ǥ礳äȲ¤ȤΤprivateˤϤޤ
  # %( )" "ƱǤ

  # Υإå
  def html_article_header
    %(<div class="#{metaphor}">\n)
  end

  # Υեå
  def html_article_footer
    "</div>\n"
  end

  # 
  def html_article_body
    html_article_title <<
    html_article_date <<
    html_article_author <<
    html_article_topic <<
    html_article_parent <<
    html_article_reference <<
    html_article_edit <<
    html_article_icon <<
    html_article_talk
  end

  # ȥ
  def html_article_title
    %(<h2 class="#{metaphor}_title">#{@a_title}</h2>\n)
  end

  # 
  def html_article_date
    t = Time::at(@a_date)
    %(<span class="#{metaphor}_date">#{t.strftime("%b.%d.%Y %H:%M'%S")}</span><br>\n)
  end

  # ԤȤؤΥ
  def html_article_author
    mail_elem = ''
    if @a_email != ''
      mail_elem = %( <a href="mailto:#{email}">#{email}</a>)
    end
    hoempage_elem = ''
    if @a_homepage != ''
      homepage_elem = %( <a href="#{homepage}">[Home]</a>)
    end
    %(<span class="#{metaphor}_author">#{@a_author}#{mail_elem}#{homepage_elem}</span><br>\n)
  end

  # ȥԥå
  def html_article_topic
    %(ȥԥå: <span class="#{metaphor}_topic">#{@a_topic}</span><br>\n)
  end

  # ƵؤΥ
  def html_article_parent
    return '' if @a_parent == ''
    tmp = @a_parent
    tmp.gsub!(/\n/, "<br>\n")
    tmp.gsub!(/@/, Baseurl+'?id=')
    %(Ƶ: <span class="#{metaphor}_parent">#{autolink(tmp)}</span><br>\n)
  end

  # 
  def html_article_reference
    return '' if @a_reference == ''
    tmp = @a_reference
    tmp.gsub(/\n/, "<br>\n")
    %(: <span class="#{metaphor}_reference">#{autolink(tmp)}</span><br>\n)
  end

  # ѹ
  def html_article_edit
    return '' if @a_edit == ''
    tmp = @a_edit    
    tmp.gsub!(/&#10;/, "<br>\n")
    %(ѹ: <span class="#{metaphor}_edit">#{tmp}</span><br>\n)
  end

  # 饢
  def html_article_icon
    return '' if @a_icon == ''
    %(<img class="#{metaphor}_icon" alt="" src="#{icon}"><br>\n)
  end

  # ʸ
  def html_article_talk
    tmp = @a_talk
    tmp.gsub!(/&#10;/, "<br>")
    tmp.gsub!(/&#32;/, ' ')
    tmp = html_talk_filter(tmp)
    %(<div class="#{metaphor}_talk">#{autolink(tmp)}</div><br>\n)
  end

  # åե륿
  # Ѥեѥ˥åŬػѸäꡣ
  def html_talk_filter(text)
    @filter['general'].each do |key, value|
    	text.gsub!(key, value)
    end
    @filter[metaphor].each do |key, value|
    	text.gsub!(key, value)
    end
    return text
  end
  
  private
  
  def init_filter
    basedir = File::dirname(ENV['PATH_TRANSLATED']).untaint + '/'
    #ե륿ݤȤnilɤΥåʤ
    #ǥեȤϥåˤƤ롣
    @filter = Hash::new(Hash::new)
    file = File::open(basedir + Filterfile, 'r')
    begin
      charactor = 'general'
      @filter[charactor] = Hash::new
      while !file.eof?
        line = file.gets.chomp!
          if line[0] == '#' || line == ''
            next
          end
          if line =~ /^::(.+)$/
            characotr = $1
            @filter[charactor] = Hash::new
            next
          end
          @filter[charactor][line] = file.gets.chomp!
        end
      ensure
    file.close
    end
  end
end
