#!/usr/bin/ruby
#---------------------------------------------------
# Limo WEB-BBS System.
#   Post Wiki - Wikiƥƥ󥿡ե
#
#                      1st Maintaner   Rero2@fumi.
#
#---------------------------------------------------

#------------------------------------
# 
# $Id: wiki_post.cgi,v 1.1 2002/05/15 14:51:43 rero2 Exp $
#
# Apr.16.2002 - rero2@fumi
#   ϡ
#
#----

require 'cgi'
require 'jcode'
require 'kconv'
require "config.rb"
require "bbs_database.rb"
require "wikiview.rb"

form_error = false
error_word = Array::new


# --- CGI 󥿡ե
input = CGI.new

post_mode = String::new(input["mode"])
if post_mode == "NEW" then
  editmode = false
else
  editmode = true
end
passwd = String::new(input["passwd"])
serial = String::new(input["serial"]).to_i
topic = String::new(input["topic"])
reference = String::new(input["reference"])
talk = String::new(input["talk"])
wikiserial = 0


# --- ʸ
topic.gsub!(/&/, '&amp;')
reference.gsub!(/&/, '&amp;')
talk.gsub!(/&/, '&amp;')
topic.gsub!(/^ /, '')
reference.gsub!(/^ /, '')
talk.gsub!(/^ /, '')
topic.gsub!(/ /, '&#32;')
reference.gsub!(/ /, '&#32;')
talk.gsub!(/ /, '&#32;')
reference.gsub!(/\n/, "&#10;\n")
reference.gsub!(/\r/, '')
talk.gsub!(/\n/, "&#10;\n")
talk.gsub!(/\r/, '')
topic.gsub!(/</, '&lt;')
topic.gsub!(/>/, '&gt;')
reference.gsub!(/</, '&lt;')
reference.gsub!(/>/, '&gt;')
talk.gsub!(/</, '&lt;')
talk.gsub!(/>/, '&gt;')


# --- ƥ
db = Ezdb::new(Datadir, Dataname)
art = WikiArticle::new(db)

# --- ȥԥåꥹȤɤ߹
topiclist = db.topic_list_read

# --- äȥԥåŤʤäƤʤ
if editmode == false
  topiclist.each do |topic_line|
    topic_line =~ /([0-9]+)\s([0-9]+)\s([0-9]+)\s(.*)/
    if ((topic == $4) && ($3.to_i > 0)) then
      error_word << "ˤȥԥåǤǤޤ\n"
      form_error = true
    end
  end 
# --- Խä饨ǥåȤڡΥꥢõ
else
  topiclist.each do |topic_line|
    topic_line =~ /([0-9]+)\s([0-9]+)\s([0-9]+)\s(.*)/
    if topic == $4 then
      wikiserial = $3.to_i
    end
  end 
  # - ȥԥå̾Ĥʤä鿷
  if wikiserial == 0 then
    editmode = false
  end
end


# --- 񤭹߲ǽɤåȥ顼
if (topic.length == 0)
  error_word << "ȥԥåϤƤޤ\n"
  form_error = true
end
if (talk.length == 0)
  error_word << "ʸϤƤޤ\n"
  form_error = true
end
if form_error == true then
  print "Content-type: text/html\n\n"
  print "<HTML>\n"
  print "<HEAD>\n"
  print "<META HTTP-EQUIV=\"Content-Type\" CONTENT=\"text/html;CHARSET=x-euc\">"
  print "<META HTTP-EQUIV=\"Refresh\" CONTENT=\"15;URL="+BaseWikiurl+"\">"
  print "</HEAD>\n"
  print "<body>"
  print "<A HREF=\""+BaseWikiurl+"\">Return Wiki.</A>"
  print "<P><HR><P>\n"
  error_word.each do |err|
    print err+"<BR>\n"
  end
  print "</body></html>\n"
  exit
end


# --- ƥ˵ơԽ
art.set_serial(wikiserial)
art.set_topic(topic)
art.set_reference(Kconv::toeuc(reference))
art.set_talk(Kconv::toeuc(talk))


# --- ǡ١åΥå
while(db.lock_check == 1)
  sleep(0.5)
end


# --- Ž񤭹ߥå
writeover = topic + talk
l = sprintf("len=%d", writeover.length)
writeover_key = l.crypt(Cryptsalt)
check_file = Datadir + 'overcheck'
if File::exist?(check_file) then
  # -- ֤ФƤ̵
  lasttime = Time::now - File::mtime(check_file)
  if lasttime < (60 * 5)
    fp = open(check_file)
    key = fp.readline
    fp.close
    if key =~ writeover_key then
      print "Content-type: text/html\n\n"
      print "<HTML>\n"
      print "<HEAD>\n"
      print "<META HTTP-EQUIV=\"Content-Type\" CONTENT=\"text/html;CHARSET=x-euc\">"
      print "<META HTTP-EQUIV=\"Refresh\" CONTENT=\"10;URL="+BaseWikiurl+"\">"
      print "</HEAD>\n"
      print "<body>"
      print "<A HREF=\""+BaseWikiurl+"\">Return Wiki.</A>"
      print "<P><HR><P>\n"
      print "Ž񤭹ߤ򸡽С򤷤ޤ\n"
      print "</body></html>\n"
      exit
    end
  end
end
fp = open(check_file, "w")
fp.print(writeover_key)
fp.close


# --- Խä鸵ƥ
if editmode == true then
  orgart = WikiArticle::new(db)
  orgart.get_article(serial)
  # --- ѹ
  diff = ''
  orgtalk = orgart.get_talk
  orgline = Array::new
  edtline = Array::new
  diffmemo = Array::new
  orgtalk.each do |line|
    orgline << line
  end
  talk.each do |line|
    edtline << line
  end
  # -- Կ¿롼״
  diffloop = 0
  if orgline.length > edtline.length then
    diffloop = orgline.length
  else
    diffloop = edtline.length
  end
  # -- 롼
  for i in 0...diffloop
    if i > orgline.length then
      diff << sprintf("%d<%s\n", i, edtline[i])
    elsif i > edtline.length then
      diff << sprintf("%d>%s\n", i, orgline[i])
    elsif edtline[i] != orgline[i] then
      diff << sprintf("%d>%s\n", i, orgline[i])
      diff << sprintf("%d<%s\n", i, edtline[i])
    end
  end
  # --- ʬ
end

# --- ƥν񤭹
if editmode == false then
  art.set_title('Wiki Article')
  art.set_layer('wikinote')
  art.write_article
else
  art.set_title('Wiki Article')
  art.set_layer('wikinote')
  art.set_date(orgart.get_date)
  art.set_reference(orgart.get_reference)
  art.set_edit(orgart.get_edit)
  art.edit_article
  orgart.set_title('Wiki Edit')
  orgart.set_edit('')
  orgart.set_layer('wikiedit')
  orgart.set_talk(diff)
  orgart.write_article
end



# --- 񤭹߽λ
return_url = PostWikidone + sprintf("?topic=%s", CGI::escape(topic))
print "Content-type: text/html\n\n"
print "<HTML>\n"
print "<HEAD>\n"
print "<META HTTP-EQUIV=\"Content-Type\" CONTENT=\"text/html;CHARSET=x-euc\">"
print "<META HTTP-EQUIV=\"Refresh\" CONTENT=\"1;URL=./"+return_url+"\">"
print "</HEAD>\n"
print "<body>"
print "<A HREF=\"./"+PostWikidone+"\">Request Accept.</A>"
print "</body></html>\n"


