#---------------------------------------------------
# Limo WEB-BBS System.
#   Wiki mode ѥҥ륭ӥ塼
#
#       1st Maintaner  rero2@fumi
#
#---------------------------------------------------

#------------------------------------
# 
#
# May.13.2002 - rero2@fumi
#   (äȤ)
#----

#---------------------------------------------------
# 饤֥䳰ե
#---------------------------------------------------

require 'cgi'
require "config.rb"
require "bbs_database.rb"
require "bbs_article.rb"
require "bbs_hierarchy.rb"


# ------------------------------------------------------ #
#  Hierarchy Class                                       #
# ------------------------------------------------------ #


#---------------------------------------------
#----- ȥԥå WikiPage Ϥ
#
class  WikiHierarchy < Hierarchy
  #-------------------------------------
  #--- ѥ᡼
  #  db = ǡ١֥
  def initialize(db)
    # --- ƥ饹θƤӽФ
    super(db)
    # --- ȥԥåꥹȤɤ߹ߡ
    @topiclist = db.topic_list_read
    # -- WikiName ϢǥȥƤ
    @wikiname = Hash::new
    @topiclist.each do |line|
      # - Wiki page å
      chunk = line.split
      if chunk[2].to_i != 0 then
        @wikiname[chunk[3]] = chunk[2].to_i
      end
    end
  end


  #-------------------------------------
  #--- Wikipage θϤ
  #  topic = ɽ Topic(WikiName)
  def get_article(topic)
    # --- ȥԥå¸ߤ뤫ɤ
    if @wikiname.key?(topic) == FALSE then
      return nil
    end
    # --- ꤵ줿ȥԥåɤ߹
    serial = @wikiname[topic]
    art = WikiArticle::new(@bbs_db)
    art.set_topiclist(@wikiname)
    art.get_article(serial-1)
    @length = 1
    return art
  end

  #-------------------------------------
  #--- Wikipage ꥹȤϤ
  def get_topiclist
    @wikiname
  end

end


# ------------------------------------------------------ #
#  Article Class (& view)                                #
# ------------------------------------------------------ #

#---------------------------------------------
#----- ĥ꡼¤ѥƥ륯饹
#
class  WikiArticle < ArticleClass
  #-------------------------------------
  #--- ѥ᡼
  #  db = ǡ١֥
  def initialize(db)
    # ----- ѡ饹ν
    super(db)
    # --- Wiki only ץѥƥ
    @topic_list = ''
    @wikiname = Hash::new
  end


  #-------------------------------------
  #--- ᥽åɷ

  # --- Hieraruchy  topic ꥹȤμ
  def set_topiclist(topic)
    @wikiname = topic
  end
  def topiclist= topic
    set_topiclist(topic)
  end
  # --- (¾ä)


  #-------------------------------------
  #--- Wiki ڡΥ
  def html_article
    output = ''
    # -- ơ֥
    output << '<table cellpadding="2" cellspacing="1" border="0" width="90%">'
    output << "\n"
    # -- ƥ륿ȥ
    art_serial = sprintf("No.%06d\n", @a_serial)
    link_serial = sprintf("<A HREF=\"%s?topic=%s\" CLASS=\"hide\">", BaseWikiurl, CGI::escape(@a_topic))
    link_serial << art_serial
    link_serial << "</A>\n"
    output << "  <tr>\n"
    output << '    <td bgcolor="#ffe080" width="24%">' + "\n"
    output << '      <font color="#000000"><b>' + "\n"
    output << link_serial
    output << "      </b></font>\n"     
    output << "    </td>\n"
    output << '    <td bgcolor="#e09040" width="76%">' + "\n"
    output << '      <font color="#ffffff" size="+1"><b>' + "\n"
    output << sprintf("        %s\n", @a_topic)
    output << "      </b></font>\n"     
    output << "    </td>\n"
    output << "  </tr>\n"
    # -- 񤭹
    t = Time::at(@a_date)
    date = sprintf("%s", t.strftime("%b.%d.%Y %H:%M'%S"))
    output << "  <tr>\n"
    output << '    <td bgcolor="#ffffcc">' + "\n"
    output << '      <font color="#505050">' + "\n"
    output << "        Date :\n"
    output << "      </font>\n"     
    output << "    </td>\n"
    output << '    <td bgcolor="#ffffff">' + "\n"
    output << '      <font color="#000000">' + "\n"
    output << sprintf("        %s\n", date)
    output << "      </font>\n"     
    output << "    </td>\n"
    output << "  </tr>\n"
    # -- ȡ
    unless @a_reference == '' then
      tmp = @a_reference
      tmp.gsub(/\n/, "<br>\n")
      output << "  <tr>\n"
      output << '    <td bgcolor="#ffffcc">' + "\n"
      output << '      <font color="#505050">' + "\n"
      output << "        Reference :\n"
      output << "      </font>\n"     
      output << "    </td>\n"
      output << '    <td bgcolor="#ffffff">' + "\n"
      output << '      <font color="#000000">' + "\n"
      output << sprintf("        %s\n", autolink(tmp))
      output << "      </font>\n"     
      output << "    </td>\n"
      output << "  </tr>\n"
    end
    # -- ѹ
    unless @a_edit == '' then
      tmp = @a_edit
      tmp.gsub!(/&#10;/, "<br>\n")
      output << "  <tr>\n"
      output << '    <td bgcolor="#ffffcc">' + "\n"
      output << '      <font color="#505050">' + "\n"
      output << "        Edit history :\n"
      output << "      </font>\n"     
      output << "    </td>\n"
      output << '    <td bgcolor="#ffffff">' + "\n"
      output << '      <font color="#000000">' + "\n"
      output << sprintf("        %s\n", tmp)
      output << "      </font>\n"     
      output << "    </td>\n"
      output << "  </tr>\n"
    end
    # -- ƥ
    tmp = @a_talk
    tmp.gsub!(/&#10;/, "<br>")
    tmp.gsub!(/&#32;/, ' ')
    output << "  <tr>\n"
    output << '    <td colspan="2" bgcolor="#fffff0">' + "\n"
    output << '      <font color="#404040">' + "\n"
    output << sprintf("        %s\n", make_wikilink(autolink(tmp)))
    output << "      </font>\n"     
    output << "    </td>\n"
    output << "  </tr>\n"
    # -- ޤ
    output << "</table>\n"
    output
  end


  # - - - - - - - - - -
  # private area

  #-------------------------------------
  #--- WikiName ؤ WikiLink 
  #    (WikiNameʬ󥯤ˤ)
  def make_wikilink(talk)
    body = String::new(talk)
    body.gsub!(/\[\[(.+)\]\]/) {
      search = $1
      urlname = CGI::escape(search)
      linktag = ''
      # ---  WikiName ¸ߤ뤫
      if @wikiname.key?(search) then
        # -- ¸ߤ餽ΥڡؤΥ
	linktag = "<A HREF=\""+BaseWikiurl+"?topic="+urlname+"\"> [["+search+"]]</A>"
      else
        # -- ¸ߤʤȤϥڡؤΥ
	linktag = "[["+search+"<A HREF=\""+WriteWikiurl+"?topic="+urlname+"\">?</A>]]"
      end
      # --- դʸ֤
      linktag
    }
    # -- 
    body
  end


end
