/* =====================================================================

   LiMo - Liblary
      Graphic Display System.  - $B2hLL$H%*%V%8%'4IM}(B

                                  Programed by Rero2 (K.Kunikane)

====================================================================== */

/* -------------------------------------------------------------
 --- History

  Sep.12.1999  Programing start
  Sep.24.1999  First release

-------------------------------------------------------------- */

/* -------------------------------------------------------------
 --- Preface

  RRScreenInit       -- $B2hLL=i4|2=(B
  RRScreenFree       -- $B2hLL<~$j3+J|(B
  RRScreenSwitch     -- $B%@%V%k%P%C%U%!%j%s%0@ZBX$((B
  RRScreenRedraw     -- Expose Event $B$G$N2hLL%j%I%m!<(B
  RRScreenBufNum     -- $B%@%V%k%P%C%U%!$N=q$-9~$_2DG=%Z!<%8$rJV$9(B
  RRScreenBuffer     -- $B8=:_$N=q$-9~$_2DG=(B Pixmap $B$rJV$9(B
  RRScreenGCColor    -- GC $B$N%+%i!<$r@_Dj$9$k(B
  RRScreenGCGet      -- GC $B$rF@$k(B
  RRScreenClear      -- $BIA2h%9%/%j!<%s$rC1?'$GEI$j$D$V$9(B
  RRScreenFontInit   -- $BIA2h%U%)%s%H$N;XDj$J$I(B
  RRScreenFontLocate -- $B%U%)%s%H$NIA2h0LCV;XDj(B
  RRScreenFontSize   -- $B%F%-%9%H$N=D2#%5%$%:(B
  RRScreenFontPrint  -- $BJ8;zNs$NI=<((B
  RRScreenFontDialog -- $B%U%)%s%H%@%$%"%m%0$G%U%)%s%H$N;XDj$r$7$F%;%C%H(B
  RRScreenPutPixmap  -- $BIA2h%9%/%j!<%s$K(BPixmap$B$rI=<((B

  RRGetParts         -- $B%t%#%8%'%C%H>e$N;XDjL>;R%t%#%8%'%C%H$rJV$9(B

-- Future Reserve ($B$=$N$&$A:n$j$^$9(B(^^;)
  RRScreenObjLoad    -- ObjectMap $BMQ2hA|%G!<%?$NFI$_9~$_!?J];}(B
  RRScreenObjPut     -- Object$B$NI=<((B
  RRScreenObjSize    -- ObjectMap $B$N%5%$%:$rF@$k(B
  RRScreenRectangle  -- $B;M3Q$NI=<((B
  RRScreenLine       -- $B%i%$%s$NI=<((B
  RRScreenPoint      -- $BE@$NI=<((B

-------------------------------------------------------------- */

/* -------------------------------------------------------------
 --- Include
-------------------------------------------------------------- */

#include <gtk/gtk.h>
#include "rr_screen.h"

/* -------------------------------------------------------------
 --- $B3F<o@_Dj;v9`(B
-------------------------------------------------------------- */

/* -------------------------------------------------------------
 --- $B%=!<%9Fb4X?t@k8@(B
-------------------------------------------------------------- */

/* -------------------------------------------------------------
 --- $B%=!<%9FbJQ?t@k8@(B
-------------------------------------------------------------- */

/* --- $B%@%V%k%9%/%j!<%s%P%C%U%!(B */
GdkPixmap *pixmap[2];

/* --- $B%9%/%j!<%s%Z!<%8(B */
gint  page;

/* --- $B%9%/%j!<%s%5%$%:(B */
gint  screen_w, screen_h;

/* --- $B%0%i%U%#%C%/%3%s%F%-%9%H(B */
GdkGC     *win_gc[3];

/* --- $BI=<(%9%/%j!<%s(B widget */
GtkWidget  *canvas;

/* --- $BJQ99$5$l$?IA2h%(%j%"$N%a%b(B */
gint  drawmemo_x, drawmemo_y, drawmemo_w, drawmemo_h;

/* --- $BI=<(%U%)%s%H$N;XDj(B */
GdkFont  *sfont1 = NULL, *sfont2= NULL;

/* --- $B%U%)%s%H$NI=<(0LCV(B */
gint  font_x, font_y;


/* -----------------------------------------------------------------------
 --- $B%$%s%W%j%a%s%H(B
------------------------------------------------------------------------ */

/* -------------------------------------------------------------
  RRScreenInit       -- $B2hLL4IM}4XO"=i4|2=(B

   return : void
   screen   - $BI=<($9$k%&%#%s%I%&%t%'%8%'%C%H(B
   name     - $B%&%#%s%I%&>e<B:]$KI=<($r9T$&(BDrawArea Widget name
   w        - $B2#%5%$%:(B
   h        - $B=D%5%$%:(B
-------------------------------------------------------------- */
void RRScreenInit(GtkWidget *screen, gchar *name, gint w, gint h)
{
  /* size keep */
  screen_w = w;
  screen_h = h;

  /* $B%I%m!<%"%V%k%(%j%"$N%A%'%C%/(B */
  canvas = RRGetParts(RRGetParts(screen, "fixed1"), name);

  /* $B%@%V%k%P%C%U%!=`Hw(B */
  pixmap[0] = gdk_pixmap_new(screen->window, w, h, -1);
  pixmap[1] = gdk_pixmap_new(screen->window, w, h, -1);
  win_gc[0] = gdk_gc_new(pixmap[0]);
  win_gc[1] = gdk_gc_new(pixmap[1]);
  win_gc[2] = gdk_gc_new(screen->window);
  page = 1;
  RRScreenClear(0, 0, 0);
  page = 0;
  RRScreenClear(0, 0, 0);
  drawmemo_x = drawmemo_y = -1;
  drawmemo_w = drawmemo_h = 0;

  /* $B$=$NB>=i4|2=(B */
  font_x = font_y = 0;
}


/* -------------------------------------------------------------
  RRScreenFree       -- $B2hLL<~$j3+J|(B

   return : void
   void
-------------------------------------------------------------- */
void       RRScreenFree(void)
{
  gdk_pixmap_unref(pixmap[0]);
  gdk_pixmap_unref(pixmap[1]);
  gdk_gc_destroy(win_gc[0]);
  gdk_gc_destroy(win_gc[1]);
  gdk_gc_destroy(win_gc[2]);
}


/* -------------------------------------------------------------
  RRScreenSwitch     -- $B%@%V%k%P%C%U%!%j%s%0@ZBX$((B

   return : $B8=:_$N=q$-9~$_2DG=%P%C%U%!HV9f(B(0-1)
   void
-------------------------------------------------------------- */
gint       RRScreenSwitch(void)
{
  /* -- $B=q$-JQ$o$C$?ItJ,$@$1$r%"%C%W%G!<%H(B */
  if ((drawmemo_w > 0) && (drawmemo_h > 0)) {
    gdk_gc_set_clip_mask(win_gc[2], NULL);
    gdk_gc_set_clip_origin(win_gc[2], 0, 0);
    gdk_draw_pixmap(canvas->window, win_gc[2], pixmap[page],
		    drawmemo_x, drawmemo_y,
		    drawmemo_x, drawmemo_y, drawmemo_w, drawmemo_h);
  }

  /* -- $B<!9T$-$^$7$g$&(B */
  page ^= 1;
  drawmemo_x = drawmemo_y = -1;
  drawmemo_w = drawmemo_h = 0;

  /* -- $BA0$N2hLL$r%3%T!<$9$k(B */
  gdk_gc_set_clip_mask(win_gc[page], NULL);
  gdk_gc_set_clip_origin(win_gc[page], 0, 0);
  gdk_draw_pixmap(pixmap[page], win_gc[page], pixmap[(page^1)], 0, 0,
		  0, 0, screen_w, screen_h);
  return(page);
}


/* -------------------------------------------------------------
  RRScreenRedraw     -- Expose Event $B$G$N2hLL%j%I%m!<(B

   $B0z?t!?%j%?!<%s$O(B expose event $B$K=`$:$k(B
-------------------------------------------------------------- */
gboolean   RRScreenRedraw(GtkWidget *win, GdkEventExpose *expose,
			  gpointer user_data)
{
  /* $B<h$j4:$($:A4LL=q$-49$($G8mKb2=$7$F$*$/(B(^^; */
  /* $B$"$H$G@55,$K:FIA2hItJ,Kh$N=hM}$K$7$J$$$H!D(B */
  gdk_gc_set_clip_mask(win_gc[(page^1)], NULL);
  gdk_gc_set_clip_origin(win_gc[(page^1)], 0, 0);
  gdk_draw_pixmap(canvas->window, win_gc[(page^1)], pixmap[(page^1)], 0, 0,
		  0, 0, screen_w, screen_h);

  return(FALSE);
}


/* -------------------------------------------------------------
  RRScreenBufNum     -- $B%@%V%k%P%C%U%!$N=q$-9~$_2DG=%Z!<%8(B

   return : $B8=:_$N=q$-9~$_2DG=%P%C%U%!HV9f(B(0-1)
   void
-------------------------------------------------------------- */
gint       RRScreenBufNum(void)
{
  return(page);
}


/* -------------------------------------------------------------
  RRScreenBuffer     -- $B8=:_$N=q$-9~$_2DG=(B Pixmap $B$rJV$9(B

   return : $B8=:_$N=q$-9~$_2DG=(BPixmap pointera
   void
-------------------------------------------------------------- */
GdkPixmap *RRScreenBuffer(void)
{
  return(pixmap[page]);
}


/* -------------------------------------------------------------
  RRScreenCanvas     -- $BI=<(%?!<%2%C%H$H$J$k%&%#%s%I%&$rJV$9(B

   return : $BI=<(%?!<%2%C%H%t%#%8%'%C%H(B
   void
-------------------------------------------------------------- */
GtkWidget *RRScreenCanvas(void)
{
  return(canvas);
}


/* -------------------------------------------------------------
  RRScreenGCColor    -- GC $B$N%+%i!<$r@_Dj$9$k(B

   return : void
   r, g, b - $B?'$N;XDj(B
-------------------------------------------------------------- */
void       RRScreenGCColor(gint r, gint g, gint b)
{
  GdkColor  col;

  col.red = r;
  col.green = g;
  col.blue = b;
  gdk_color_alloc(gdk_colormap_get_system()  ,&col);
  gdk_gc_set_foreground(win_gc[page], &col);
}


/* -------------------------------------------------------------
  RRScreenGCGet      -- GC $B$rF@$k(B

   return : void
   void
-------------------------------------------------------------- */
GdkGC     *RRScreenGCGet(void)
{
  return(win_gc[page]);
}


/* -------------------------------------------------------------
  RRScreenClear      -- $BIA2h%9%/%j!<%s$rC1?'$GEI$j$D$V$9(B

   return : void
   r, g, b - $B?'$N;XDj(B
-------------------------------------------------------------- */
void       RRScreenClear(gint r, gint g, gint b)
{
  RRScreenGCColor(r, g, b);
  gdk_draw_rectangle(pixmap[page], win_gc[page], TRUE,
		     0, 0, screen_w, screen_h);
  drawmemo_x = drawmemo_y = 0;
  drawmemo_w = screen_w;
  drawmemo_h = screen_h;
}


/* -------------------------------------------------------------
  RRScreenFontInit   -- $BIA2h%U%)%s%H$N;XDj$J$I(B

   return : void
   fontname - $B%U%)%s%H%;%C%HL>(B
-------------------------------------------------------------- */
void       RRScreenFontInit(gchar *fontname)
{
  if (fontname != NULL)
    sfont1 = gdk_fontset_load(fontname);
}


/* -------------------------------------------------------------
  RRScreenFontLocate -- $B%U%)%s%H$NIA2h0LCV;XDj(B

   return : void
   x, y - $B:BI8$N;XDj(B
-------------------------------------------------------------- */
void       RRScreenFontLocate(gint x, gint y)
{
  font_x = x;
  font_y = y;
}


/* -------------------------------------------------------------
  RRScreenFontSize -- $BI=<(J8;zNs$N=D2#%5%$%:(B

   return : void
   disp - $BJ8;zNs(B
   *w, *h - $B%5%$%:(B
-------------------------------------------------------------- */
void       RRScreenFontSize(gchar *disp, gint *w, gint*h)
{
  *w = gdk_string_width(sfont1, disp);
  *h = gdk_string_height(sfont1, disp);
}


/* -------------------------------------------------------------
  RRScreenFontPrint  -- $BJ8;zNs$NI=<((B

   return : void
   disp - $B:BI8$N;XDj(B
-------------------------------------------------------------- */
void       RRScreenFontPrint(gchar *disp)
{
  gint  w, h;

  w = gdk_string_width(sfont1, disp);
  h = gdk_string_height(sfont1, disp);
  gdk_draw_string(pixmap[page], sfont1, win_gc[page],
		  font_x, font_y+h-1, disp);
  /* -- $B=q$-JQ$o$C$?%(%j%"$N5-O?(B */
  if ((drawmemo_x < 0) || (drawmemo_x > font_x)) drawmemo_x = font_x;
  if ((drawmemo_y < 0) || (drawmemo_y > font_y)) drawmemo_y = font_y;
  if ((drawmemo_w == 0) ||
      ((drawmemo_w + drawmemo_x) < (font_x + w))) {
    drawmemo_w = (font_x + w) - drawmemo_x;
  }
  if ((drawmemo_h == 0) ||
      ((drawmemo_h + drawmemo_y) < (font_y + h))) {
    drawmemo_h = (font_y + h) - drawmemo_y;
  }
}


/* -------------------------------------------------------------
  RRScreenFontDialog -- $B%U%)%s%H%@%$%"%m%0$G%U%)%s%H$N;XDj$r$7$F%;%C%H(B

   return : void
   void
-------------------------------------------------------------- */
void       RRScreenFontDialog(void)
{
  /* -- $B8=:_$O%U%)%s%H%@%$%"%m%0$GF|K\8l%U%)%s%H$,@_Dj$G$-$J$$$N$G>JN,(B */
}


/* -------------------------------------------------------------
  RRScreenPutPixmap  -- $BIA2h%9%/%j!<%s$K(BPixmap$B$rI=<((B

   return : void
   picture - $BE>AwI=<($7$?$$2hA|(B
   x, y - $BI=<(0LCV%*%U%;%C%H(B
-------------------------------------------------------------- */
void       RRScreenPutPixmap(GdkPixmap *picture,  gint x, gint y)
{
  gint  w, h;

  gdk_window_get_size(picture, &w, &h);
  gdk_gc_set_clip_mask(win_gc[page], NULL);
  gdk_gc_set_clip_origin(win_gc[page], x, y);
  gdk_draw_pixmap(pixmap[page], win_gc[page], picture, 0, 0,
		  x, y, w, h);
  /* -- $B=q$-JQ$o$C$?%(%j%"$N5-O?(B */
  if ((drawmemo_x < 0) || (drawmemo_x > x)) drawmemo_x = x;
  if ((drawmemo_y < 0) || (drawmemo_y > y)) drawmemo_y = y;
  if ((drawmemo_w == 0) ||
      ((drawmemo_w + drawmemo_x) < (x + w))) {
    drawmemo_w = (x + w) - drawmemo_x;
  }
  if ((drawmemo_h == 0) ||
      ((drawmemo_h + drawmemo_y) < (y + h))) {
    drawmemo_h = (y + h) - drawmemo_y;
  }
}




/* -------------------------------------------------------------
  RRGetParts         -- $B%t%#%8%'%C%H>e$N;XDjL>;R%t%#%8%'%C%H$rJV$9(B

   return : void
   mainwin - $BC5$985?F(B widget
   name - $BC5$9(B widget name
-------------------------------------------------------------- */
GtkWidget *RRGetParts(GtkWidget *mainwin, gchar *name)
{
  GtkWidget *parts = NULL;
  GList *wlist, *tmp;
  gint  n, i;
  gint max;

  wlist = gtk_container_children(GTK_CONTAINER(mainwin));
  max = g_list_length(wlist);
  n = -1;
  for(i=0; i<max; i++) {
    tmp = g_list_nth(wlist, i);
    parts = GTK_WIDGET(tmp->data);
    if (strcmp((char*)gtk_widget_get_name(parts), name) == 0) {
      /* -- $B$_!<$D$1$?(B */
      n = i;
      break;
    }
  }
  if (n == -1) {
    parts = NULL;
  }

  return(parts);
}
